#!/usr/bin/perl

use strict;
use warnings;
use FabForce::DBDesigner4::DBIC;
use Getopt::Long;

GetOptions(
  'ns=s'   => \my $namespace,
  'file=s' => \my $file,
  'path=s' => \my $path,
);

my $dbic = FabForce::DBDesigner4::DBIC->new();

print_usage() unless $file;

$dbic->namespace( $namespace ) if defined $namespace;
$dbic->output_path( $path )    if defined $path;

$dbic->create_scheme( $file );

sub print_usage {
    print qq~Usage: $0 -file modell.xml parameters

Parameters:
  required:
    file: The xml file generated by FabForce DBDesigner
  
  optional:
    ns:   The namespace the schema belongs to
    path: output path
~;
    exit;
}