#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::HostingSlnInt
#     ABSTRACT:  identify Hosting Solutions International (ASN30083) owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Wed Nov 19 11:00:13 PST 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::HostingSlnInt;     # _ENTITY_REGEX_ Hosting Solutions

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known Hosting Solutions International (ASN30083) IP blocks as of Nov 2014
    $self->ips(qw(
        50.30.32.0 - 50.30.47.255
        69.64.32.0 - 69.64.63.255
        173.224.112.0 - 173.224.127.255
        199.189.84.0 - 199.189.87.255
        199.217.112.0 - 199.217.119.255
        209.126.96.0 - 209.126.127.255
        209.239.112.0 - 209.239.127.255
    ));
    return $self;
}

sub name {
    return 'HostingSlnInt';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::HostingSlnInt - identify Hosting Solutions International (ASN30083) owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::HostingSlnInt;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::HostingSlnInt identifies Hosting Solutions International (ASN30083) host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::HostingSlnInt object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
