#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::B2_Net
#     ABSTRACT:  identify B2_Net Solutions (AS55286) owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Sun Oct 12 19:32:46 PDT 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::B2_Net;  # _ENTITY_REGEX_ B2.Net

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known B2_Net Solutions (AS55286) IP blocks as of Sept 2014
    $self->ips(qw(
        23.229.0.0 - 23.229.127.255
        23.236.128.0 - 23.236.255.255
        23.250.0.0 - 23.250.127.255
        23.254.0.0 - 23.254.127.255
        69.4.80.0 - 69.4.95.255
        69.58.0.0 - 69.58.15.255
        104.144.0.0 - 104.144.255.255
        104.227.0.0 - 104.227.255.255
        107.152.128.0 - 107.152.255.255
        138.128.0.0 - 138.128.127.255
        192.157.48.0 - 192.157.63.255
        192.186.128.0 - 192.186.191.255
        192.198.96.0 - 192.198.127.255
        192.241.64.0 - 192.241.127.255
        198.20.160.0 - 198.20.191.255
        198.154.80.0 - 198.154.95.255
        192.157.48.0 - 192.157.63.255
        198.245.64.0 - 198.245.79.255
    ));
    return $self;
}

sub name {
    return 'B2_Net';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::B2_Net - identify B2_Net Solutions (AS55286) owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::B2_Net;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::B2_Net identifies B2_Net Solutions (AS55286) host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::B2_Net object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
