package Net::Douban;
our $VERSION = '1.03';

use Moose;
use Carp qw/carp croak/;

with 'Net::Douban::Roles';

#my $oauth;    ## magic global variable
## use this to enable globle value
#sub oauth {
#    my $self = shift;
#    if (@_) {
#        $oauth = shift;
#        return \$oauth;
#    } else {
#        return \$oauth;
#    }
#}

#around 'oauth' => sub {
#    my $orig = shift;
#    my $self = shift;
#    if(@_){
#        $oauth = shift;
#        return \$oauth;
#    }else{
#        return \$oauth;
#    }
#};

our $AUTOLOAD;

sub AUTOLOAD {
    my $self = shift;
    (my $name = $AUTOLOAD) =~ s/.*:://g;
    return if $name eq 'DESTORY';
    if ($name eq 'OAuth') {
        require Net::Douban::OAuth;
        return "Net::Douban::OAuth"->new(
            $self->args,
            instance => $self,
            @_,
        );
    }
    if (grep {/^$name$/}
        qw/User Note Tag Collection Recommendation Event Review Subject Doumail Miniblog OAuth/
      )
    {
        my $class = "Net::Douban::$name";
        eval "require $class";
        my $obj = "Net::Douban::$name"->new($self->args, @_,);
        return $obj;
    }
    croak "Unknow Method!";
}

sub DESTORY { }

#deprecated in order to keep it simple
#around 'BUILDARGS' => sub {
#    my $orig = shift;
#    my $self = shift;
#    my %args = @_;
#    my $auth = delete $args{oauth} if exists $args{oauth};
#    $oauth = $auth;
#    $self->$orig(%args);
#};
#
no Moose;
__PACKAGE__->meta->make_immutable;

1;
__END__

=pod

=head1 NAME1

Net::Douban

=head1 VERSION

version 1.03

=head1 SYNOPSIS
    
    use Net::Douban;
    use Net::Douban::OAuth;
    my $consumer = Net::Douban::OAuth->new(...);
    my $client = Net::Douban->new( oauth =>$consumer);

    my $atom = $client->User(userID => 'Net-Douban')->get_user;
    print $atom->id;
    ....

=head1 DESCRIPTION

Net::Douban is a perl client wapper on the Chinese website 'Douban.com' API.

=head1 METHODS

=over

=item B<new>

    $client = Net::Douban->new(oauth => $consumer, apikey => $key);

=item B<Auto-Generated Objects>
    
    #Net::Douba::User object
    $client->User;

    #Net::Douban::Event object
    $clent->Event;
    ...

Auto-generated objects include: B<User Note Tag Collection Recommendation Event Review Subject Doumail Miniblog OAuth>

=back

=head1 SEE ALSO
    
L<Net::Douban> L<Net::Douban::Atom> L<Moose> L<XML::Atom> L<http://douban.com/service/apidoc>

=head1 AUTHOR

woosley.xu<redicaps@gmail.com>

=head1 COPYRIGHT & LICENSE

This software is copyright (c) 2010 by woosley.xu.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
