#!/usr/bin/perl
# $Id: Makefile.PL 6 2009-07-26 03:54:11Z rcaputo $

use ExtUtils::MakeMaker;

## Touch CHANGES so it exists.
open(CHANGES, ">>CHANGES") and close CHANGES;

WriteMakefile(
	NAME         => 'CDDB',
	AUTHOR       => 'Rocco Caputo <rcaputo@cpan.org>',
	ABSTRACT     => 'High-level interface to CDDB and freedb servers.',
	LICENSE      => 'perl',
	VERSION_FROM => 'lib/CDDB.pm',
	PREREQ_PM    => {
		'Test::More' => 0,
	},
	dist         => {
		COMPRESS   => 'gzip -9',
		SUFFIX     => 'gz',
		PREOP      => (
			'svn-log.perl | tee ./$(DISTNAME)-$(VERSION)/CHANGES > ./CHANGES'
		),
	},
);
