#!/usr/bin/perl
##################################################################
# web_ini.pl - Gets the data to update in the ini.pm             #
#              from the Merge Configuration Web page             #
# Author : Eial Solodki                                          #
# All right reserved - Raz Information Systems Ltd.(c) 1999-2001 #
# Date : 07/05/2001                                              #
# updated :                                                      #
##################################################################

use HTML::Merge::Engine;
use CGI qw/:standard/;
use strict qw(vars subs);
my $MERGE_ABSOLUTE_PATH = param('MERGE_ABSOLUTE_PATH');
my $MERGE_SCRIPT = param('MERGE_SCRIPT');

my $file = "$MERGE_ABSOLUTE_PATH/$MERGE_SCRIPT";
$file =~ s/\.\w+$/.conf/;

my $date = pack("A21", scalar(localtime));

my $state = 0;
open(INPUT, $file);
my @lines;
while (<INPUT>) {
	chop;
	if (!$state) {
		$state++ if /^package/;
	} elsif ($state == 1) {
		$state++ if /^#/;
	} else {
		next if /^#/;
		@lines = ($_);
		last;
	}
}

while (<INPUT>) {
        chop;
	last if (/^return /);
	push(@lines, $_);
}

close(INPUT);

my @vars = param();
my %hash;
@hash{@vars} = @vars;
my $code;
my $db_pass = HTML::Merge::Engine::Convert(param('DB_PASSWORD'), 1);

foreach my $v (@vars) {
	my $item =join(",", grep /./, param($v));
	$item =~ s/'/\\'/g;
	if ($v eq 'SUPPORT_SITE') {
		eval '
			use URI::Heuristic qw(uf_uristr);
			$item = uf_uristr($item);
		';
	}
	if ($v eq 'DB_PASSWORD2') {
		$item = $db_pass;
	}
	if ($v eq 'DB_PASSWORD') {
		$item = '';
	}

	foreach (@lines) {
		if (s/\$$v\s*=.*$/\$$v = '$item';/) {
			delete $hash{$v};
		}
	}
}

if (%hash) {
	push(@lines);
	foreach (keys %hash) {
		my $item = join(",", grep /./, param($_));
		$item =~ s/'/\\'/g;
		push(@lines, "\$$_ = '$item';");
	}
}

unless (open(OUTPUT, ">$file")) {
	print "Status: 403 Permission denied\n";
	print "Content-type: text/plain\n\n";
	print "Could not rewrite $file: $!";
	exit;
}

print OUTPUT "#####################################################################
package HTML::Merge::Ini;
#####################################################################
# ini - Contains enviroment vars - the Merge configuration file     #	
# Authors : Roi Illouz & Eial Solodki                               #
# All right reserved - Raz Information Systems Ltd.(c) 1999-2001    #
# Date : 21/03/1998				                    #
# Last update : $date				    #
# Automatic page  - generated by the Merge Configuration Web page   #
#####################################################################
";
print OUTPUT join("\n", @lines, "");
print OUTPUT "return 1;\n";
print OUTPUT "############################################################################\n";

close OUTPUT;

do $file;

print "Location: $HTML::Merge::Ini::MERGE_PATH/private/perl/pre_web_ini.pl?merge_path=$HTML::Merge::Ini::MERGE_PATH/$HTML::Merge::Ini::MERGE_SCRIPT&merge_absolute_path=$HTML::Merge::Ini::MERGE_ABSOLUTE_PATH\n\n";
