<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Pcap - libpcap bindings

SYNOPSIS
========

    use Net::Pcap;
    use Net::Packet :short;

    # Live capturing
    my $pcap = Net::Pcap.create("eth0");
    $pcap.filter('portrange 1-1024');
    $pcap.activate;

    # Read from file
    my $pcap = Net::Pcap.offline_open('./capture.pcap');

    loop $pcap.next_ex -> ($hdr, $frame) {
        my $eth = Ethernet.decode($frame);

        say sprintf 'Time:   %.3f', $hdr.seconds;
        say sprintf 'Length: %d (%d captured)', $hdr.len, $hdr.caplen;
        say sprintf 'Ethernet:';
        say sprintf '  Source:      %s', $eth.src;
        say sprintf '  Destination: %s', $eth.dst;

        if $eth.pl ~~ IPv4 {
     	    say sprintf 'IPv4:';
	    say sprintf '  Source:      %s', $eth.pl.src;
	    say sprintf '  Destination: %s', $eth.pl.dst;
        }
    }

EXPORTS
=======

    class Net::Pcap

DESCRIPTION
===========



class Net::Pcap::pcap_pkthdr_t
------------------------------

    is repr('CStruct')

    Implements `pcap_pkthdr_t`.

### Attributes

    $.tv_sec   is int
    $.tv_usec  is int
    $.caplen   is int
    $.len      is int

### Methods

    .seconds() returns Real
      Combines the $.tv_sec and $.tv_usec fields to one Real.

    .clone() returns Net::Pcap::pcap_pkthdr_t
      Returns a copy of this structure.

class Net::Pcap
---------------

    is repr('CPointer')

    Implements `pcap_t`.

### Methods

    .create(Str $source="any") returns Net::Pcap
      Constructor for Net::Pcap for live-capturing, uses pcap_create(). Use .activate() on it.

    .open_offline(Str $fname) returns Net::Pcap
      Constructor for Net::Pcap to open capture files, uses pcap_open_offline().

    .open_dead(Int $linktype, Int $snaplen) returns Net::Pcap
      Constructor for creating a fake Net::Pcap.

    .close()
      Calls pcap_close().

    .activate()
      Activates the capture devices, uses pcap_activate().

    .next() returns Parcel
      Get next frame.

      *Usage of .next_ex() is preferred due to better error messages!*

      Returns a parcel with two elements:
      - Net::Pcap::pcap_pkthdr_t structure
      - Net::Pcap::C_Buf containing the frame.
      Uses pcap_next().

    .next_ex() returns Parcel
      Get next frame.

      Returns a parcel with two elements:
      - Net::Pcap::pcap_pkthdr_t structure
      - Net::Pcap::C_Buf containing the frame.
      Uses pcap_next_ex().

    .filter(Str $str, Int $optimize = 0, Int $netmask = 0xFFFFFFFF)
      Apply filter $str.

      Calls pcap_compile(), pcap_freecode() and pcap_setfilter().

    .findalldevs() returns Array
      Find all available capture devices. Uses pcap_findalldevs().

      Returns an array of hashes, each hash contains the keys:
      - name
      - description
      - flags
