package Test::Alien::CanCompile;

use strict;
use warnings;
use Test::Stream::Context qw( context );
use Test::Stream::Plugin;

# ABSTRACT: Skip a test file unless a C compiler is available
our $VERSION = '0.02'; # VERSION


sub load_ts_plugin
{
  require ExtUtils::CBuilder;
  
  my $skip = !ExtUtils::CBuilder->new->have_compiler;
  
  return unless $skip;

  my $ctx = context();
  $ctx->plan(0, "SKIP", "This test requires a compiler.");
  $ctx->release;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Test::Alien::CanCompile - Skip a test file unless a C compiler is available

=head1 VERSION

version 0.02

=head1 DESCRIPTION

This is just a L<Test::Stream> plugin that requires that a compiler
be available.  Otherwise the test will be skipped.

=head1

 use Test::Alien::CanCompile;

=head1 SEE ALSO

=over 4

=item L<Test::Alien>

=back

=head1 AUTHOR

Graham Ollis <plicease@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Graham Ollis.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
