package FFI::Platypus::Bundle::Constant;

use strict;
use warnings;
use constant 1.32 ();
use FFI::Platypus;

# ABSTRACT: Platypus Bundle Constant code
our $VERSION = '0.95_05'; # TRIAL VERSION


{
  my $ffi = FFI::Platypus->new( api => 1, experimental => 1 );
  $ffi->bundle;

  $ffi->type( 'opaque'                       => 'ffi_pl_bundle_t' );
  $ffi->type( '(string,string)->void' => 'set_str_t'       );
  $ffi->type( '(string,sint64)->void' => 'set_sint_t'      );
  $ffi->type( '(string,uint64)->void' => 'set_uint_t'      );
  $ffi->type( '(string,double)->void' => 'set_double_t'    );

  $ffi->mangler(sub {
    my($name) = @_;
    $name =~ s/^/ffi_platypus_bundle_api__/;
    $name;
  });

  $ffi->attach( new => [ 'set_str_t', 'set_sint_t', 'set_uint_t', 'set_double_t' ] => 'opaque' => sub {
    my($xsub, $class, $default_package) = @_;
    my $f = $ffi->closure(sub {
      my($name, $value) = @_;
      if($name !~ /::/)
      {
        $name = join('::', $default_package, $name);
      }
      constant->import($name, $value);
    });

    bless {
      ptr => $xsub->($f, $f, $f, $f),
      f   => $f,
    }, $class;
  });

  $ffi->attach( DESTROY => ['opaque'] => 'void' => sub {
    my($xsub, $self) = @_;
    $xsub->($self->ptr);
  });

  sub ptr { shift->{ptr} }

}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

FFI::Platypus::Bundle::Constant - Platypus Bundle Constant code

=head1 VERSION

version 0.95_05

=head1 DESCRIPTION

This class is private to L<FFI::Platypus>.

=head1 AUTHOR

Author: Graham Ollis E<lt>plicease@cpan.orgE<gt>

Contributors:

Bakkiaraj Murugesan (bakkiaraj)

Dylan Cali (calid)

pipcet

Zaki Mughal (zmughal)

Fitz Elliott (felliott)

Vickenty Fesunov (vyf)

Gregor Herrmann (gregoa)

Shlomi Fish (shlomif)

Damyan Ivanov

Ilya Pavlov (Ilya33)

Petr Pisar (ppisar)

Mohammad S Anwar (MANWAR)

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015,2016,2017,2018,2019 by Graham Ollis.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
