package Clustericious::Plugin::ClustericiousHelpers;

use strict;
use warnings;
use 5.010001;
use Carp qw( carp );
use base qw( Mojolicious::Plugin );
use Mojo::ByteStream qw( b );

# ABSTRACT: Helpers for Clustericious
our $VERSION = '1.11'; # VERSION


sub register
{
  my ($self, $app, $conf) = @_;


  $app->helper(auth_ua => sub {
    my($c) = @_;
    carp "auth_ua has been deprecated";
    $c->ua;
  });


  $app->helper(base_tag => sub {
    my $base = $app->config->url_base(default => '');
    carp "base_tag is deprecated";
    b("<base href='$base' />");
  });


  $app->helper(render_moved => sub {
    my($c,@args) = @_;
    $c->res->code(301);
    my $where = $c->url_for(@args)->to_abs;
    $c->res->headers->location($where);
    $c->render(text => "moved to $where");
  });
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Clustericious::Plugin::ClustericiousHelpers - Helpers for Clustericious

=head1 VERSION

version 1.11

=head1 DESCRIPTION

This class provides helpers for Clustericious.

=head1 HELPERS

In addition to the helpers provided by
L<Mojolicious::Plugin::DefaultHelpers> you get:

=head2 auth_ua

B<DEPRECATED>

Returns an instance of L<Mojo::UserAgent> that can be used
to authenticate against a L<PlugAuth> service.  Used primarily
for testing.

=head2 base_tag

B<DEPRECATED>

=head2 render_moved

 $c->render_moved($path);

Render a 301 response.

=head1 AUTHOR

Original author: Brian Duggan

Current maintainer: Graham Ollis E<lt>plicease@cpan.orgE<gt>

Contributors:

Curt Tilmes

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by NASA GSFC.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
