package Alien::Librdkafka;
 
use strict;
use warnings;
use base 'Alien::Base';

# ABSTRACT: build and install librdkafka
our $VERSION = '1.04_01'; # TRIAL VERSION
$VERSION = eval $VERSION; ## no critic (BuiltinFunctions::ProhibitStringyEval)







1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Alien::Librdkafka - build and install librdkafka

=head1 VERSION

version 1.04_01

=head1 SYNOPSIS

In your Makefile.PL:

 use ExtUtils::MakeMaker;
 use Alien::Base::Wrapper ();

 WriteMakefile(
   Alien::Base::Wrapper->new('Alien::Librdkafka')->mm_args2(
     # MakeMaker args
     NAME => 'Kafka::Librd',
     ...
   ),
 );

In your Build.PL:

 use Module::Build;
 use Alien::Base::Wrapper qw( Alien::Librdkafka !export );

 my $builder = Module::Build->new(
   ...
   configure_requires => {
     'Alien::Librdkafka' => '0',
     ...
   },
   Alien::Base::Wrapper->mb_args,
   ...
 );

 $build->create_build_script;

=head1 DESCRIPTION

This distribution provides librdkafka so that it can be used by other
Perl distributions that are on CPAN.  It does this by first trying to
detect an existing install of librdkafka on your system.  If found it
will use that.  If it cannot be found, the source code will be downloaded
from the internet and it will be installed in a private share location
for the use of other modules.

=head1 SEE ALSO

L<Alien>, L<Alien::Base>, L<Alien::Build::Manual::AlienUser>

=head1 AUTHOR

Original author: Pavel Shaydo

Current maintainer: Graham Ollis E<lt>plicease@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016, 2017, 2018 by Pavel Shaydo.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
