# @(#)$Id: Build.PL 85 2010-04-29 11:37:05Z pjf $

use strict;
use warnings;
use version; our $VERSION = qv( sprintf '0.3.%d', q$Rev: 85 $ =~ /\d+/gmx );

use Module::Build;

my $build = Module::Build->new
   ( add_to_cleanup     => [ q(Debian_CPANTS.txt), q(HTML-Accessors-*),
                             map { ( '*/' x $_ ) . '*~' } 0..5 ],
     build_requires     => { 'Test::More' => q(0.74) },
     configure_requires => { 'version'    => q(0.74) },
     create_readme      => 1,
     create_packlist    => 0,
     dist_version_from  => q(lib/HTML/Accessors.pm),
     license            => q(perl),
     module_name        => q(HTML::Accessors),
     no_index           => { directory => [ q(t) ] },
     requires           => {
        'perl'                  => q(5.008),
        'parent'                => q(0.221),
        'version'               => q(0.74),
        'Class::Accessor::Fast' => q(0.31),
        'HTML::GenerateUtil'    => q(1.08),
        'HTML::Tagset'          => q(3.10) },
     sign               => 1, );

$build->create_build_script();

# Local Variables:
# mode: perl
# tab-width: 3
# End:
