package WordList::EN::PersonName::PopularBabyNames::US::SSA::1980::FemaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-04'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.002'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contains_unicode",0,"longest_word_len",11,"num_words_contains_nonword_chars",0,"num_words_contain_nonword_chars",0,"shortest_word_len",2,"num_words_contain_unicode",0,"num_words",1000,"num_words_contains_whitespace",0,"avg_word_len",6.013,"num_words_contain_whitespace",0); # STATS

1;
# ABSTRACT: Top 1000 most popular names for female babies born in the USA in 1980 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyNames::US::SSA::1980::FemaleTop1000 - Top 1000 most popular names for female babies born in the USA in 1980 (from Social Security Administration)

=head1 VERSION

This document describes version 0.002 of WordList::EN::PersonName::PopularBabyNames::US::SSA::1980::FemaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyNames-US-SSA), released on 2020-05-04.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyNames::US::SSA::1980::FemaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyNames::US::SSA::1980::FemaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 6.013 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Jennifer
Amanda
Jessica
Melissa
Sarah
Heather
Nicole
Amy
Elizabeth
Michelle
Kimberly
Angela
Stephanie
Tiffany
Christina
Lisa
Rebecca
Crystal
Kelly
Erin
Laura
Amber
Rachel
Jamie
April
Mary
Sara
Andrea
Shannon
Megan
Emily
Julie
Danielle
Erica
Katherine
Maria
Kristin
Lauren
Kristen
Ashley
Christine
Brandy
Tara
Katie
Monica
Carrie
Alicia
Courtney
Misty
Kathryn
Patricia
Holly
Stacy
Karen
Anna
Tracy
Brooke
Samantha
Allison
Melanie
Leslie
Brandi
Susan
Cynthia
Natalie
Jill
Dawn
Dana
Vanessa
Veronica
Lindsay
Tina
Kristina
Stacey
Wendy
Lori
Catherine
Kristy
Heidi
Sandra
Jacqueline
Kathleen
Christy
Leah
Valerie
Pamela
Erika
Tanya
Natasha
Katrina
Lindsey
Melinda
Monique
Teresa
Denise
Tammy
Tonya
Julia
Candice
Gina
Alison
Nichole
Theresa
Victoria
Margaret
Beth
Renee
Tamara
Robin
Linda
Nancy
Anne
Sabrina
Meghan
Brenda
Jaime
Jenny
Diana
Cheryl
Barbara
Krista
Kristi
Latoya
Bethany
Kelli
Michele
Kara
Miranda
Sharon
Tasha
Mindy
Mandy
Molly
Candace
Ann
Casey
Colleen
Cassandra
Suzanne
Meredith
Latasha
Rachael
Regina
Donna
Marie
Deborah
Carolyn
Nina
Deanna
Cindy
Alisha
Carla
Bridget
Kendra
Desiree
Tabitha
Yolanda
Kari
Summer
Virginia
Trisha
Rebekah
Joanna
Felicia
Joy
Bonnie
Jodi
Jaclyn
Angel
Adrienne
Jillian
Janet
Paula
Aimee
Ebony
Abigail
Debra
Martha
Rhonda
Autumn
Shanna
Robyn
Carmen
Angelica
Shelly
Toni
Priscilla
Shawna
Kristine
Brittany
Claudia
Sherry
Marissa
Janelle
Laurie
Stefanie
Kate
Ana
Melody
Caroline
Diane
Tamika
Cara
Alexis
Rosa
Kellie
Tracey
Ruth
Sonia
Naomi
Cristina
Audrey
Hannah
Sheila
Sonya
Jasmine
Alyssa
Leigh
Whitney
Krystal
Yvonne
Stacie
Anita
Shauna
Rose
Shelley
Traci
Olivia
Kerri
Christie
Tia
Carol
Adriana
Brianne
Marisa
Kelley
Kristie
Jenna
Gloria
Leticia
Charlene
Terri
Morgan
Charity
Latisha
Nikki
Jana
Angie
Jacquelyn
Jeanette
Karla
Christa
Lynn
Becky
Kathy
Tricia
Janice
Annie
Kerry
Ellen
Keri
Amie
Annette
Sylvia
Rachelle
Alissa
Frances
Abby
Lesley
Bobbie
Gretchen
Shana
Lakisha
Helen
Jami
Latonya
Lacey
Dorothy
Keisha
Maureen
Mayra
Jennie
Yvette
Alexandra
Roxanne
Johanna
Lydia
Evelyn
Sandy
Sherri
Charlotte
Irene
Jody
Tameka
Esther
Chasity
Eva
Rita
Connie
Hillary
Raquel
Lorena
Jessie
Juanita
Faith
Billie
Brandie
Angelina
Hope
Staci
Miriam
Jane
Elaine
Cassie
Amelia
Maribel
Grace
Jocelyn
Norma
Joni
Rochelle
Elisabeth
Carly
Tanisha
Ginger
Hilary
Alice
Sally
Meagan
Joyce
Lakeisha
Carissa
Jenifer
Devon
Beverly
Renata
Jolene
Randi
Elisa
Tabatha
Brianna
Sheri
Kirsten
Joanne
Tracie
Leanne
Jean
Belinda
Jackie
Mia
Karina
Chrystal
Ericka
Camille
Bobbi
Corinne
Ruby
Alma
Betty
Marisol
Cecilia
Darlene
Kasey
Lee
Caitlin
Sophia
Patrice
Alana
Elena
Sasha
Bianca
Serena
Elisha
Alisa
Aisha
Jodie
Eileen
Gabriela
Shirley
Terra
Briana
Christi
Ryan
Kim
Joann
Hollie
Judith
Trina
Antoinette
Guadalupe
Lakesha
Celeste
Marilyn
Lara
Rosemary
Chandra
Marsha
Katharine
Kimberley
Nora
Cathy
Gabrielle
Allyson
Claire
Melisa
Lacy
Penny
Judy
Michael
Nadia
Mandi
Chelsea
Betsy
Marcia
Lora
Emma
Dena
Daisy
Tami
Kenya
Esmeralda
Christin
Audra
Genevieve
Lillian
Yesenia
Janine
Iris
Katy
Josephine
Lorraine
Tania
Teri
Lena
Isabel
Blanca
Jayme
Debbie
Haley
Peggy
Gwendolyn
Leann
Shelby
Wanda
Aubrey
Roberta
Alyson
Christen
Laurel
Jeannette
Jeannie
Lashonda
Marcie
Paige
Tiffanie
Cherie
Lea
Alejandra
Cortney
Angelique
Liza
Marcy
Darcy
Maggie
Lana
Margarita
Brittney
Catrina
Carolina
Shameka
Selena
Tiffani
Misti
Noelle
Marci
Cheri
Destiny
Marlene
Shayla
Lucy
Candy
Bridgette
Ashlee
Bernadette
Lynette
Dara
Susana
Larissa
Clarissa
Dina
Joan
Luz
Jeanne
Loretta
Marla
Marianne
Adrianne
Raven
Rhiannon
Vivian
Alaina
Latosha
Brook
Vicki
Kristal
Janel
Maya
Sonja
Tonia
Dianna
Clara
Shawn
Mariah
Maranda
Tiana
Nicolette
Jordan
Kimberlee
Kisha
Arlene
Latanya
Latrice
Corina
Myra
Janna
Tessa
Candi
Christian
Sheryl
Elissa
Tera
Marcella
Malinda
Deana
Wendi
Jasmin
Constance
Shari
Araceli
Jo
Devin
Adrian
Athena
Sue
Carey
Meaghan
Dayna
Deidra
Janell
Maritza
Edith
Karin
Tisha
Chrissy
Antonia
Anya
Nadine
Georgia
Irma
Marina
Marjorie
Tammie
Elise
Justine
Lawanda
Kylie
Maricela
Glenda
Syreeta
Loni
Rocio
Breanne
Olga
Tosha
Bridgett
Bambi
Deidre
Maryann
Chastity
Ramona
Shamika
Janie
Lucia
Silvia
Angelia
Cori
Darla
Dominique
Janette
Talia
Andria
Jeanine
Kayla
Christopher
Ladonna
Lynda
Aja
Ariana
Renae
Kelsey
Leanna
Alecia
Kami
Jason
Kyla
Rena
Shanda
Gail
Chantel
Dora
Marlena
Tori
Brenna
Shavon
Sharonda
Doris
Natalia
Valarie
Noemi
Quiana
Ashleigh
Cari
Christal
Terry
Jesse
Breanna
David
Gladys
Lashanda
Dusty
Vickie
Cristy
Ingrid
Beatrice
Pauline
Lucinda
Mollie
Daphne
Delia
Liliana
Sheree
Demetria
Racheal
Edna
Leeann
Ivy
Ronda
Sherrie
Siobhan
Sommer
Chanel
Corey
Regan
Karyn
Dolores
Celia
Sadie
Taryn
Abbey
Eliza
Jade
Karrie
James
Josie
Michaela
Dionne
Julianne
Lyndsey
Rene
Shanta
Yadira
Shanika
Mara
Shalonda
Nakia
Casandra
Eleanor
Geneva
Rosalinda
Susanna
Vicky
Callie
Lindy
Robert
Hilda
Alanna
Caryn
Francesca
John
Griselda
Mellissa
Precious
Mercedes
Rosemarie
Beatriz
Charmaine
Cristin
Elsa
Ami
Holli
Starla
Alexandria
Mariana
Darci
Deirdre
Jeanna
Sunshine
Graciela
Renada
Alesha
Jaimie
Marisela
Annmarie
Louise
Shonda
Taylor
Celina
Jeri
Jacklyn
June
Mackenzie
Madeline
Maura
Selina
Abbie
Brandee
Georgina
Hayley
Lakeshia
Lorie
Meghann
Stella
Tawana
Tomeka
Jamila
Kandice
Simone
Anastasia
Laquita
Kia
Martina
Daniela
Katina
Kristyn
Leilani
Susie
Jenelle
Joshua
Sondra
Emilie
Kiley
Juana
Shasta
Shavonne
Tamra
Tanesha
Daniel
Shantel
Carina
Danelle
Helena
Shelia
Joseph
Marta
William
Eve
Harmony
Karissa
Marian
Cora
Cory
Mindi
Juliana
Kesha
Monika
Starr
Tammi
Aileen
Charissa
Corrine
Lynne
Fatima
Shara
Corrie
Gena
Ida
Kira
Qiana
Rosalyn
Tanika
Lyndsay
Aurora
Malissa
Viviana
Eboni
Jena
Kristan
Adriane
Desirae
Jeanie
Bertha
Kerrie
Mellisa
Rosanna
Casie
Sunny
Venessa
Bree
Francine
Lourdes
Greta
Jammie
Sherita
Jeannine
Kacey
Shayna
Jada
Shante
Matthew
Jerri
Ashanti
Niki
Sofia
Adrianna
Chanda
Colette
Kacie
Kathrine
Kendall
Marion
Noel
Octavia
Stacia
Janae
Lily
Lizette
Richelle
Shannan
Venus
Cathleen
Salina
Jan
Trista
Britney
Chiquita
Latesha
Leila
Letitia
Sierra
Eugenia
Melina
Juliet
Susanne
Ariel
Lacie
Nikole
Phyllis
Felecia
Alexa
Angeline
Tarah
Delores
Nakisha
Nikia
Shanon
Angelita
Bernice
Deanne
Joelle
Annemarie
Cheyenne
Davina
Eunice
Mari
Gwen
Josefina
Missy
Princess
Shanita
Tamera
Ella
Kandi
Aaron
Brian
Gillian
Justina
Kori
Kyle
Keli
Deena
Dixie
Reyna
Blair
Farrah
Jenni
Rebeca
Star
Elaina
Jeana
Pearl
Tyra
Chimere
Leona
Magdalena
Margie
Perla
Tawanda
Valencia
Ada
Francisca
Nichol
Ursula
Chana
Fawn
Rikki
Stephenie
Kaci
Margo
Johnna
Tenisha
Anabel
Crissy
Leia
Reagan
Rosalie
Adria
Anthony
Brynn
Cecelia
Justin
Kenyatta
Vera
Consuelo
Danica
Darcie
Laci
Lisette
Tai
Tomika
Asia
Delilah
Loren
Lynnette
Maren
Mildred
Sandi
Bettina
Damaris
Keely
Shantell
Mona
Dianne
Iesha
Paulette
Shellie
Tana
Alysia
Candis
Kirstin
Alina
Ashlie
Kellee
Rosie
Shea
Therese
Charla
Eric
Francis
Kay
Lissette
Lois
Raina
Rashida
Shawanda
Tracee
Windy
Florence
Lina
Renita
Suzanna
Alena
Alycia
Cristal
Jessi
Lashawn
Lola
Cameron
Lila
Krissy
Kylene
Linsey
Malia
Nicki
Liana
Thelma
Chantelle
Julianna
Kati
Lashunda
Mariel
