package WordListMod::ScanPick;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-22'; # DATE
our $DIST = 'WordListMod-ScanPick'; # DIST
our $VERSION = '0.001'; # VERSION

use strict 'subs', 'vars';
use warnings;

our @patches = (
    ['pick', 'replace', sub {
         my ($self, $n) = @_;

         $n = 1 if !defined $n;
         die "Please specify a positive number of words to pick" if $n < 1;

         if ($n == 1) {
             my $i = 0;
             my $word;
             # algorithm from Learning Perl
             $self->each_word(
                 sub {
                     $i++;
                     $word = $_[0] if rand($i) < 1;
                 }
             );
             return $word;
         }

         my $i = 0;
    my @words;
         $self->each_word(
             sub {
                 $i++;
                 if (@words < $n) {
                # we haven't reached $n, put word to result in a random position
                     splice @words, rand(@words+1), 0, $_[0];
                 } else {
                     # we have reached $n, just replace a word randomly, using
                     # algorithm from Learning Perl, slightly modified
                     rand($i) < @words and splice @words, rand(@words), 1, $_[0];
                 }
             }
         );
         @words;
     }],
);

1;
# ABSTRACT: Provide the default scan pick()

__END__

=pod

=encoding UTF-8

=head1 NAME

WordListMod::ScanPick - Provide the default scan pick()

=head1 VERSION

This document describes version 0.001 of WordListMod::ScanPick (from Perl distribution WordListMod-ScanPick), released on 2020-05-22.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordListMod-ScanPick>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordListMod-ScanPick>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordListMod-ScanPick>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<WordLListMod::RandomSeekPick>

L<WordList>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
