package TableData::AOH;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-04-13'; # DATE
our $DIST = 'TableDataRoles-Standard'; # DIST
our $VERSION = '0.008'; # VERSION

use strict;
use warnings;

use Role::Tiny::With;
with 'TableDataRole::Source::AOH';

1;
# ABSTRACT: Get table data from array of hashes

__END__

=pod

=encoding UTF-8

=head1 NAME

TableData::AOH - Get table data from array of hashes

=head1 VERSION

This document describes version 0.008 of TableData::AOH (from Perl distribution TableDataRoles-Standard), released on 2021-04-13.

=head1 SYNOPSIS

 use TableData::AOH;

 my $table = TableData::DBI->new(
     aoh => [{col1=>1,col2=>2}, {col1=>3,col2=>4}],
 );

=head1 DESCRIPTION

This is a TableData:: module to get table data from array of hashes.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/TableDataRoles-Standard>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-TableDataRoles-Standard>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://github.com/perlancar/perl-TableDataRoles-Standard/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<TableData>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
