package Sah::SchemaR::sah::schema_modname;

our $DATE = '2020-05-08'; # DATE
our $VERSION = '0.9.49.1'; # VERSION

our $rschema = ["str",[{description=>"\nPerl module name, e.g. `Foo`, `Foo::Bar`.\n\nContains coercion rule so you can also input `Foo-Bar`, `Foo/Bar`, or\n`Foo/Bar.pm` and it will be normalized into `Foo::Bar`.\n\nSee also: `perl::modargs`.\n\n",match=>"\\A[A-Za-z_][A-Za-z_0-9]*(::[A-Za-z_0-9]+)*\\z",summary=>"Perl module name","x.completion"=>"perl_modname","x.perl.coerce_rules"=>["From_str::normalize_perl_modname"]},{summary=>"Name of a Sah::Schema::* module, without the prefix","x.completion"=>["perl_modname",{ns_prefix=>"Sah::Schema"}]}],["perl::modname","str"]];

1;
# ABSTRACT: Name of a Sah::Schema::* module, without the prefix

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::sah::schema_modname - Name of a Sah::Schema::* module, without the prefix

=head1 VERSION

This document describes version 0.9.49.1 of Sah::SchemaR::sah::schema_modname (from Perl distribution Sah-Schemas-Sah), released on 2020-05-08.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Sah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Sah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Sah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020, 2019, 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
