package PERLANCAR::Debian::Releases;

our $DATE = '2015-09-22'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

use Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(
                       list_debian_releases
               );

our %SPEC;

# BEGIN FRAGMENT id=meta
# note: This section is generated by a script. Do not edit manually!
# src-file: /mnt/home/s1/repos/gudangdata/table/debian_release/meta.yaml
# src-revision: 5759af125cce118c0913b7d3e3a06b430de0ea49
# revision-date: Tue Sep 22 19:39:29 2015 +0700
# generate-date: Tue Sep 22 19:39:51 2015
# generated-by: /mnt/home/s1/repos/gudangdata/bin/gen-perl-meta-snippet
our $meta = {
  fields => {
    code_name     => { pos => 1, schema => "str*", sortable => 1, summary => "Code name", unique => 1 },
    eoldate       => { pos => 3, schema => "date*", sortable => 1, summary => "End of life date" },
    kernelver     => { pos => 6, schema => "str*", sortable => 1, summary => "Kernel version" },
    lprel_reldate => {
                       pos => 5,
                       schema => "date*",
                       sortable => 1,
                       summary => "Latest point release date",
                     },
    lprel_version => {
                       pos => 4,
                       schema => "str*",
                       sortable => 1,
                       summary => "Latest point release version",
                     },
    perlver       => { pos => 7, schema => "str*", sortable => 1, summary => "Perl version" },
    reldate       => { pos => 2, schema => "date*", sortable => 1, summary => "Release date" },
    version       => { pos => 0, schema => "str*", sortable => 1, summary => "Version", unique => 1 },
  },
  pk => "version",
  summary => "Debian releases",
};
# END FRAGMENT id=meta
# BEGIN FRAGMENT id=data
# note: This section is generated by a script. Do not edit manually!
# src-file: /mnt/home/s1/repos/gudangdata/table/debian_release/data.csv
# src-revision: 5759af125cce118c0913b7d3e3a06b430de0ea49
# revision-date: Tue Sep 22 19:39:29 2015 +0700
# generate-date: Tue Sep 22 19:39:51 2015
# generated-by: /mnt/home/s1/repos/gudangdata/bin/gen-perl-data-snippet
our $data = [
    ['1.1','buzz','1996-17-06','','','','',''],
    ['1.2','rex','1996-12-12','','','','',''],
    ['1.3','bo','1997-07-02','','','','',''],
    ['2.0','hamm','1998-07-24','','','','',''],
    ['2.1','slink','1999-03-09','2000-10-30','','','',''],
    ['2.2','potato','2000-08-15','2003-06-30','','','',''],
    ['3.0','woody','2002-07-19','2006-06-30','','','',''],
    ['3.1','sarge','2005-06-06','2008-03-31','','','',''],
    ['4.0','etch','2007-04-08','2010-02-15','','','',''],
    ['5.0','lenny','2009-02-14','2012-02-06','','','',''],
    ['6.0','squeeze','2011-02-06','2016-02-28','6.0.10','2014-07-19','2.6.32','5.10.1'],
    ['7.0','wheezy','2013-05-04','','7.9.0','2015-09-05','3.2.0','5.14.2'],
    ['8.0','jessie','2015-04-25','','8.2.0','2015-09-05','3.16.0','5.20.2'],
]
;
# END FRAGMENT id=data

my $res = gen_read_table_func(
    name => 'list_debian_releases',
    table_data => $data,
    table_spec => $meta,
    #langs => ['en_US', 'id_ID'],
);
die "BUG: Can't generate func: $res->[0] - $res->[1]" unless $res->[0] == 200;

1;
# ABSTRACT: List Debian releases

__END__

=pod

=encoding UTF-8

=head1 NAME

PERLANCAR::Debian::Releases - List Debian releases

=head1 VERSION

This document describes version 0.02 of PERLANCAR::Debian::Releases (from Perl distribution PERLANCAR-Debian-Releases), released on 2015-09-22.

=head1 SYNOPSIS

 use PERLANCAR::Debian::Releases;
 my $res = list_debian_releases(detail=>1);
 # raw data is in $PERLANCAR::Debian::Releases::data;

=head1 DESCRIPTION

This module contains list of Debian releases. Data source is currently at:
https://github.com/perlancar/gudangdata (table/debian_release).

This release is made while waiting for the new release of L<Debian::Releases>
which was promised in 2014 and will contain extra data as well.

=head1 FUNCTIONS


=head2 list_debian_releases(%args) -> [status, msg, result, meta]

Debian releases.

REPLACE ME

Arguments ('*' denotes required arguments):

=over 4

=item * B<code_name> => I<str>

Only return records where the 'code_name' field equals specified value.

=item * B<code_name.contains> => I<str>

Only return records where the 'code_name' field contains specified text.

=item * B<code_name.in> => I<array[str]>

Only return records where the 'code_name' field is in the specified values.

=item * B<code_name.is> => I<str>

Only return records where the 'code_name' field equals specified value.

=item * B<code_name.isnt> => I<str>

Only return records where the 'code_name' field does not equal specified value.

=item * B<code_name.max> => I<str>

Only return records where the 'code_name' field is less than or equal to specified value.

=item * B<code_name.min> => I<str>

Only return records where the 'code_name' field is greater than or equal to specified value.

=item * B<code_name.not_contains> => I<str>

Only return records where the 'code_name' field does not contain specified text.

=item * B<code_name.not_in> => I<array[str]>

Only return records where the 'code_name' field is not in the specified values.

=item * B<code_name.xmax> => I<str>

Only return records where the 'code_name' field is less than specified value.

=item * B<code_name.xmin> => I<str>

Only return records where the 'code_name' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<eoldate> => I<date>

Only return records where the 'eoldate' field equals specified value.

=item * B<eoldate.in> => I<array[date]>

Only return records where the 'eoldate' field is in the specified values.

=item * B<eoldate.is> => I<date>

Only return records where the 'eoldate' field equals specified value.

=item * B<eoldate.isnt> => I<date>

Only return records where the 'eoldate' field does not equal specified value.

=item * B<eoldate.max> => I<date>

Only return records where the 'eoldate' field is less than or equal to specified value.

=item * B<eoldate.min> => I<date>

Only return records where the 'eoldate' field is greater than or equal to specified value.

=item * B<eoldate.not_in> => I<array[date]>

Only return records where the 'eoldate' field is not in the specified values.

=item * B<eoldate.xmax> => I<date>

Only return records where the 'eoldate' field is less than specified value.

=item * B<eoldate.xmin> => I<date>

Only return records where the 'eoldate' field is greater than specified value.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<kernelver> => I<str>

Only return records where the 'kernelver' field equals specified value.

=item * B<kernelver.contains> => I<str>

Only return records where the 'kernelver' field contains specified text.

=item * B<kernelver.in> => I<array[str]>

Only return records where the 'kernelver' field is in the specified values.

=item * B<kernelver.is> => I<str>

Only return records where the 'kernelver' field equals specified value.

=item * B<kernelver.isnt> => I<str>

Only return records where the 'kernelver' field does not equal specified value.

=item * B<kernelver.max> => I<str>

Only return records where the 'kernelver' field is less than or equal to specified value.

=item * B<kernelver.min> => I<str>

Only return records where the 'kernelver' field is greater than or equal to specified value.

=item * B<kernelver.not_contains> => I<str>

Only return records where the 'kernelver' field does not contain specified text.

=item * B<kernelver.not_in> => I<array[str]>

Only return records where the 'kernelver' field is not in the specified values.

=item * B<kernelver.xmax> => I<str>

Only return records where the 'kernelver' field is less than specified value.

=item * B<kernelver.xmin> => I<str>

Only return records where the 'kernelver' field is greater than specified value.

=item * B<lprel_reldate> => I<date>

Only return records where the 'lprel_reldate' field equals specified value.

=item * B<lprel_reldate.in> => I<array[date]>

Only return records where the 'lprel_reldate' field is in the specified values.

=item * B<lprel_reldate.is> => I<date>

Only return records where the 'lprel_reldate' field equals specified value.

=item * B<lprel_reldate.isnt> => I<date>

Only return records where the 'lprel_reldate' field does not equal specified value.

=item * B<lprel_reldate.max> => I<date>

Only return records where the 'lprel_reldate' field is less than or equal to specified value.

=item * B<lprel_reldate.min> => I<date>

Only return records where the 'lprel_reldate' field is greater than or equal to specified value.

=item * B<lprel_reldate.not_in> => I<array[date]>

Only return records where the 'lprel_reldate' field is not in the specified values.

=item * B<lprel_reldate.xmax> => I<date>

Only return records where the 'lprel_reldate' field is less than specified value.

=item * B<lprel_reldate.xmin> => I<date>

Only return records where the 'lprel_reldate' field is greater than specified value.

=item * B<lprel_version> => I<str>

Only return records where the 'lprel_version' field equals specified value.

=item * B<lprel_version.contains> => I<str>

Only return records where the 'lprel_version' field contains specified text.

=item * B<lprel_version.in> => I<array[str]>

Only return records where the 'lprel_version' field is in the specified values.

=item * B<lprel_version.is> => I<str>

Only return records where the 'lprel_version' field equals specified value.

=item * B<lprel_version.isnt> => I<str>

Only return records where the 'lprel_version' field does not equal specified value.

=item * B<lprel_version.max> => I<str>

Only return records where the 'lprel_version' field is less than or equal to specified value.

=item * B<lprel_version.min> => I<str>

Only return records where the 'lprel_version' field is greater than or equal to specified value.

=item * B<lprel_version.not_contains> => I<str>

Only return records where the 'lprel_version' field does not contain specified text.

=item * B<lprel_version.not_in> => I<array[str]>

Only return records where the 'lprel_version' field is not in the specified values.

=item * B<lprel_version.xmax> => I<str>

Only return records where the 'lprel_version' field is less than specified value.

=item * B<lprel_version.xmin> => I<str>

Only return records where the 'lprel_version' field is greater than specified value.

=item * B<perlver> => I<str>

Only return records where the 'perlver' field equals specified value.

=item * B<perlver.contains> => I<str>

Only return records where the 'perlver' field contains specified text.

=item * B<perlver.in> => I<array[str]>

Only return records where the 'perlver' field is in the specified values.

=item * B<perlver.is> => I<str>

Only return records where the 'perlver' field equals specified value.

=item * B<perlver.isnt> => I<str>

Only return records where the 'perlver' field does not equal specified value.

=item * B<perlver.max> => I<str>

Only return records where the 'perlver' field is less than or equal to specified value.

=item * B<perlver.min> => I<str>

Only return records where the 'perlver' field is greater than or equal to specified value.

=item * B<perlver.not_contains> => I<str>

Only return records where the 'perlver' field does not contain specified text.

=item * B<perlver.not_in> => I<array[str]>

Only return records where the 'perlver' field is not in the specified values.

=item * B<perlver.xmax> => I<str>

Only return records where the 'perlver' field is less than specified value.

=item * B<perlver.xmin> => I<str>

Only return records where the 'perlver' field is greater than specified value.

=item * B<query> => I<str>

Search.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<reldate> => I<date>

Only return records where the 'reldate' field equals specified value.

=item * B<reldate.in> => I<array[date]>

Only return records where the 'reldate' field is in the specified values.

=item * B<reldate.is> => I<date>

Only return records where the 'reldate' field equals specified value.

=item * B<reldate.isnt> => I<date>

Only return records where the 'reldate' field does not equal specified value.

=item * B<reldate.max> => I<date>

Only return records where the 'reldate' field is less than or equal to specified value.

=item * B<reldate.min> => I<date>

Only return records where the 'reldate' field is greater than or equal to specified value.

=item * B<reldate.not_in> => I<array[date]>

Only return records where the 'reldate' field is not in the specified values.

=item * B<reldate.xmax> => I<date>

Only return records where the 'reldate' field is less than specified value.

=item * B<reldate.xmin> => I<date>

Only return records where the 'reldate' field is greater than specified value.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<str>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<version> => I<str>

Only return records where the 'version' field equals specified value.

=item * B<version.contains> => I<str>

Only return records where the 'version' field contains specified text.

=item * B<version.in> => I<array[str]>

Only return records where the 'version' field is in the specified values.

=item * B<version.is> => I<str>

Only return records where the 'version' field equals specified value.

=item * B<version.isnt> => I<str>

Only return records where the 'version' field does not equal specified value.

=item * B<version.max> => I<str>

Only return records where the 'version' field is less than or equal to specified value.

=item * B<version.min> => I<str>

Only return records where the 'version' field is greater than or equal to specified value.

=item * B<version.not_contains> => I<str>

Only return records where the 'version' field does not contain specified text.

=item * B<version.not_in> => I<array[str]>

Only return records where the 'version' field is not in the specified values.

=item * B<version.xmax> => I<str>

Only return records where the 'version' field is less than specified value.

=item * B<version.xmin> => I<str>

Only return records where the 'version' field is greater than specified value.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hash/associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).

=back

Returns an enveloped result (an array).

First element (status) is an integer containing HTTP status code
(200 means OK, 4xx caller error, 5xx function error). Second element
(msg) is a string containing error message, or 'OK' if status is
200. Third element (result) is optional, the actual result. Fourth
element (meta) is called result metadata and is optional, a hash
that contains extra information.

Return value:  (any)

=head1 SEE ALSO

L<Ubuntu::Releases>

L<Debian::Releases>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/PERLANCAR-Debian-Releases>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-PERLANCAR-Debian-Releases>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=PERLANCAR-Debian-Releases>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
