package Devel::Caller::Util;

our $DATE = '2015-07-26'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use warnings;
use strict;

use Exporter qw(import);
our @EXPORT_OK = qw(callers);

sub callers {
    my $start = shift // 0;

    my @res;
    my $i = $start+1;
    while (my @caller = caller($i)) {
        push @res, \@caller;
        $i++;
    }

    @res;
}

1;
# ABSTRACT: caller()-related utility routines

__END__

=pod

=encoding UTF-8

=head1 NAME

Devel::Caller::Util - caller()-related utility routines

=head1 VERSION

This document describes version 0.01 of Devel::Caller::Util (from Perl distribution Devel-Caller-Util), released on 2015-07-26.

=head1 SYNOPSIS

 use Devel::Util::Caller qw(callers);

 my @callers = callers();

=head1 FUNCTIONS

=head2 callers([ $n ]) => LIST

=head1 SEE ALSO

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Devel-Caller-Util>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Devel-Caller-Util>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Devel-Caller-Util>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
