package Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic;

our $DATE = '2016-06-18'; # DATE
our $VERSION = '0.005'; # VERSION

our $scenario = {
    summary => 'Benchmark parse_arithmetic()',
    modules => {
    },
    participants => [
        {
            fcall_template => 'PERLANCAR::Parse::Arithmetic::parse_arithmetic(<expr>)',
        },
        {
            fcall_template => 'PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic(<expr>)',
        },
        {
            fcall_template => 'PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic(<expr>)',
        },
        {
            fcall_template => 'PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic(<expr>)',
        },
    ],
    datasets => [
        {
            args => {expr => '1'},
        },
        {
            args => {expr => '1' . ('+1' x (  2-1)) },
        },
        {
            args => {expr => '1' . ('+1' x (  5-1)) },
        },
        {
            name => '1+1+..+1 (10x)',
            args => {expr => '1' . ('+1' x ( 10-1)) } },
        {
            name => '1+1+..+1 (20x)',
            args => {expr => '1' . ('+1' x ( 20-1)) },
        },
        {
            name => '1+1+..+1 (100x)',
            args => {expr => '1' . ('+1' x (100-1)) },
        },
        {
            name => '1+1+..+1 (200x)',
            args => {expr => '1' . ('+1' x (200-1)) },
        },
        {
            name => '1+1+..+1 (500x)',
            args => {expr => '1' . ('+1' x (500-1)) },
        },
        {
            name => '1+1+..+1 (1000x)',
            args => {expr => '1' . ('+1' x (1000-1)) },
        },
    ],
};

1;
# ABSTRACT: Benchmark parse_arithmetic()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic - Benchmark parse_arithmetic()

=head1 VERSION

This document describes version 0.005 of Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic (from Perl distribution Bencher-Scenarios-PERLANCARParseArithmetic), released on 2016-06-18.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCARParseArithmetic::parse_arithmetic

To run module startup overhead benchmark:

 % bencher --module-startup -m PERLANCARParseArithmetic::parse_arithmetic

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<PERLANCAR::Parse::Arithmetic> 0.004

L<PERLANCAR::Parse::Arithmetic::Marpa> 0.004

L<PERLANCAR::Parse::Arithmetic::NoHash> 0.004

L<PERLANCAR::Parse::Arithmetic::Pegex> 0.004

=head1 BENCHMARK PARTICIPANTS

=over

=item * PERLANCAR::Parse::Arithmetic::parse_arithmetic (perl_code)

Function call template:

 PERLANCAR::Parse::Arithmetic::parse_arithmetic(<expr>)



=item * PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic (perl_code)

Function call template:

 PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic(<expr>)



=item * PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic (perl_code)

Function call template:

 PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic(<expr>)



=item * PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic (perl_code)

Function call template:

 PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic(<expr>)



=back

=head1 BENCHMARK DATASETS

=over

=item * 1

=item * 1+1

=item * 1+1+1+1+1

=item * 1+1+..+1 (10x)

=item * 1+1+..+1 (20x)

=item * 1+1+..+1 (100x)

=item * 1+1+..+1 (200x)

=item * 1+1+..+1 (500x)

=item * 1+1+..+1 (1000x)

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCARParseArithmetic::parse_arithmetic >>):

 +--------------------------------------------------------+------------------+-----------+-------------+------------+---------+---------+
 | participant                                            | dataset          | rate (/s) |  time (ms)  | vs_slowest |  errors | samples |
 +--------------------------------------------------------+------------------+-----------+-------------+------------+---------+---------+
 | PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic  | 1+1+..+1 (1000x) |      24.6 | 40.7        |       1    |   2e-05 |      20 |
 | PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic  | 1+1+..+1 (500x)  |      46.1 | 21.7        |       1.88 | 8.9e-06 |      20 |
 | PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic  | 1+1+..+1 (200x)  |      96.1 | 10.4        |       3.91 | 6.9e-06 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (1000x) |     111   |  9.03       |       4.51 | 4.6e-06 |      20 |
 | PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic  | 1+1+..+1 (100x)  |     150   |  6.65       |       6.11 |   2e-06 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (500x)  |     218   |  4.59       |       8.87 | 1.5e-06 |      20 |
 | PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic  | 1+1+..+1 (20x)   |     275   |  3.64       |      11.2  | 9.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic  | 1+1+..+1 (10x)   |     306   |  3.26       |      12.5  | 6.9e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic  | 1+1+1+1+1        |     325   |  3.08       |      13.2  | 6.9e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic  | 1                |     330   |  3          |      14    | 9.6e-06 |      20 |
 | PERLANCAR::Parse::Arithmetic::Pegex::parse_arithmetic  | 1+1              |     338   |  2.96       |      13.7  | 6.8e-07 |      21 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (1000x) |     361   |  2.77       |      14.7  | 9.7e-07 |      24 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (1000x) |     387   |  2.58       |      15.8  | 4.2e-07 |      21 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (200x)  |     492   |  2.03       |      20    | 1.3e-06 |      21 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (500x)  |     713   |  1.4        |      29    | 6.9e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (500x)  |     773   |  1.29       |      31.4  | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (100x)  |     840   |  1.19       |      34.2  | 9.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (200x)  |    1760   |  0.568      |      71.6  | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (200x)  |    1900   |  0.526      |      77.4  | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (20x)   |    2000   |  0.5        |      81.4  |   2e-07 |      22 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (10x)   |    2430   |  0.412      |      98.8  | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+1+1+1        |    2730   |  0.367      |     111    | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1              |    2990   |  0.334      |     122    | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1                |    3200   |  0.313      |     130    | 2.1e-07 |      21 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (100x)  |    3480   |  0.288      |     141    | 2.1e-07 |      21 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (100x)  |    3740   |  0.267      |     152    | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (20x)   |   17200   |  0.0581     |     701    | 2.5e-08 |      22 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (20x)   |   18000   |  0.0555     |     733    |   2e-08 |      36 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (10x)   |   34600   |  0.0289     |    1410    | 1.3e-08 |      22 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (10x)   |   36100   |  0.0277     |    1470    | 1.3e-08 |      21 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+1+1+1        |   66500   |  0.015      |    2710    |   6e-09 |      25 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+1+1+1        |   71900   |  0.0139     |    2920    | 6.4e-09 |      22 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1              |  160000   |  0.00627    |    6490    | 2.9e-09 |      27 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1              |  170000   |  0.0059     |    6900    | 6.7e-09 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1                |  291000   |  0.00344    |   11800    | 1.5e-09 |      24 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1                |  300408   |  0.00332881 |   12222.6  |   0     |      30 |
 +--------------------------------------------------------+------------------+-----------+-------------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m PERLANCARParseArithmetic::parse_arithmetic --module-startup >>):

 +--------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                          | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +--------------------------------------+-----------+------------------------+------------+---------+---------+
 | PERLANCAR::Parse::Arithmetic::Marpa  | 55        |                   52.4 | 1          | 5.1e-05 |      20 |
 | PERLANCAR::Parse::Arithmetic::Pegex  | 11        |                    8.4 | 4.8        | 2.3e-05 |      22 |
 | PERLANCAR::Parse::Arithmetic         | 4.8       |                    2.2 | 12         | 1.2e-05 |      21 |
 | PERLANCAR::Parse::Arithmetic::NoHash | 4.8       |                    2.2 | 12         | 8.5e-06 |      20 |
 | perl -e1 (baseline)                  | 2.6       |                    0   | 21         | 5.3e-06 |      21 |
 +--------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCARParseArithmetic>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCARParseArithmetic>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCARParseArithmetic>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
