package Bencher::Scenario::PERLANCAR::require;

our $DATE = '2016-01-21'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark require() in a tight loop/subroutine',
    participants => [
        {
            name=>'baseline_empty_sub',
            code_template=>' ',
        },
        {
            name=>'require_in_sub',
            code_template=>'require File::Find',
        },
        {
            name=>'require_in_state',
            code_template=>'state $dummy = do { require File::Find }',
        },
    ],
};

1;
# ABSTRACT: Benchmark require() in a tight loop/subroutine

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCAR::require - Benchmark require() in a tight loop/subroutine

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::PERLANCAR::require (from Perl distribution Bencher-Scenarios-PERLANCAR), released on 2016-01-21.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCAR::require

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * baseline_empty_sub (perl_code)

Code template:

  



=item * require_in_sub (perl_code)

Code template:

 require File::Find



=item * require_in_state (perl_code)

Code template:

 state $dummy = do { require File::Find }



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCAR::require >>):

 +--------------------+------------+-----------+---------+---------+
 | participant        | rate (/s)  | time (ns) | errors  | samples |
 +--------------------+------------+-----------+---------+---------+
 | require_in_sub     | 1.4e+07    | 72        | 4.4e-10 | 23      |
 | require_in_state   | 1.3179e+08 | 7.58782   | 0       | 21      |
 | baseline_empty_sub | 1e+09      | 0.8       | 1.1e-10 | 20      |
 +--------------------+------------+-----------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
