package Bencher::Scenario::MojoDOM::Parsing;

our $DATE = '2016-04-12'; # DATE
our $VERSION = '0.003'; # VERSION

use 5.010001;
use strict;
use warnings;

use Bencher::ScenarioUtil::MojoDOM;
use PERLANCAR::HTML::Tree::Examples qw(gen_sample_data);

our $scenario = {
    summary => 'Benchmark parsing of HTML',
    description => <<'_',

Sample documents from `PERLANCAR::HTML::Tree::Examples` are used.

_
    before_gen_items => sub {
        # prepare html
        %main::htmls = map {
            ($_->{name} => gen_sample_data(size => $_->{name}))
        } @Bencher::ScenarioUtil::MojoDOM::datasets;
    },
    participants => [
        {
            fcall_template => 'Mojo::DOM->new($main::htmls{<size>})',
        },
    ],
    datasets => \@Bencher::ScenarioUtil::MojoDOM::datasets,
    include_result_size => 1,
    extra_modules => \@Bencher::ScenarioUtil::MojoDOM::extra_modules,
};

1;
# ABSTRACT: Benchmark parsing of HTML

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::MojoDOM::Parsing - Benchmark parsing of HTML

=head1 VERSION

This document describes version 0.003 of Bencher::Scenario::MojoDOM::Parsing (from Perl distribution Bencher-Scenarios-MojoDOM), released on 2016-04-12.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m MojoDOM::Parsing

To run module startup overhead benchmark:

 % bencher --module-startup -m MojoDOM::Parsing

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Mojo::DOM>

=head1 BENCHMARK PARTICIPANTS

=over

=item * Mojo::DOM::new (perl_code)

Function call template:

 Mojo::DOM->new($main::htmls{<size>})



=back

=head1 BENCHMARK DATASETS

=over

=item * small1

16 elements, 4 levels

=item * medium1

20k elements, 7 levels

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m MojoDOM::Parsing >>):

 +---------+----------------+-----------+-----------+------------+------------------+---------+---------+
 | dataset | arg_expr       | rate (/s) | time (ms) | vs_slowest | result_size (MB) | errors  | samples |
 +---------+----------------+-----------+-----------+------------+------------------+---------+---------+
 | medium1 | h4:first-child | 2.78      | 360       | 1          | 24.3             | 0.00025 | 20      |
 | medium1 | h4             | 2.8       | 3.6e+02   | 1          | 24               | 0.00042 | 21      |
 | small1  | h4             | 3.6e+03   | 0.27      | 1.3e+03    | 0.019            | 4.1e-07 | 22      |
 | small1  | h4:first-child | 3.67e+03  | 0.272     | 1.32e+03   | 0.0194           | 2e-07   | 22      |
 +---------+----------------+-----------+-----------+------------+------------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m MojoDOM::Parsing --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Mojo::DOM           | 36        | 31.5                   | 1          | 0.00016 | 20      |
 | perl -e1 (baseline) | 4.5       | 0                      | 8          | 4.1e-05 | 20      |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Sample documents from C<PERLANCAR::HTML::Tree::Examples> are used.


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-MojoDOM>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-MojoDOM>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-MojoDOM>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
