package Bencher::Scenario::DataSah::Validate;

our $DATE = '2016-05-20'; # DATE
our $VERSION = '0.06'; # VERSION

require Data::Sah;
require DateTime;
require Time::Moment;

my $return_types = ['bool', 'str', 'full'];

our $scenario = {
    summary => 'Benchmark validation',
    participants => [
        {
            name => 'gen_validator',
            code_template => 'state $v = Data::Sah::gen_validator(<schema>, {return_type => <return_type>}); $v->(<data>)',
        },
    ],
    datasets => [
        {
            name => 'int',
            args => {
                schema => 'int',
                'data@' => [undef, 1, "a"],
                'return_type@' => $return_types,
            },
        },
        {
            name => 'str+2clause',
            args => {
                schema => ['str', min_len=>1, max_len=>5],
                'data@' => [undef, "abc", ""],
                'return_type@' => $return_types,
            },
        },
        {
            name => 'date (coerce to float(epoch))',
            args => {
                schema => ['date'],
                'data@' => [undef, "abc", 1463371843, "2016-05-16", DateTime->now,
                            #Time::Moment->now, # disabled for now, error
                        ],
                'return_type@' => $return_types,
            },
        },
        # XXX: date (coerce to DateTime)
        # XXX: date (coerce to Time::Moment)
    ],
};

1;
# ABSTRACT: Benchmark validation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::Validate - Benchmark validation

=head1 VERSION

This document describes version 0.06 of Bencher::Scenario::DataSah::Validate (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-05-20.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::Validate

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_validator (perl_code)

Code template:

 state $v = Data::Sah::gen_validator(<schema>, {return_type => <return_type>}); $v->(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * int

=item * str+2clause

=item * date (coerce to float(epoch))

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSah::Validate >>):

 +-------------------------------+---------------------+-----------------+-----------+-----------+------------+---------+---------+
 | dataset                       | arg_data            | arg_return_type | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +-------------------------------+---------------------+-----------------+-----------+-----------+------------+---------+---------+
 | date (coerce to float(epoch)) | 2016-05-20T09:29:55 | full            | 2.6e+04   | 38        | 1          | 4.7e-08 | 26      |
 | date (coerce to float(epoch)) | 2016-05-20T09:29:55 | bool            | 2.6e+04   | 38        | 1          | 5.3e-08 | 20      |
 | date (coerce to float(epoch)) | 2016-05-20T09:29:55 | str             | 2.7e+04   | 37        | 1          | 5.3e-08 | 20      |
 | date (coerce to float(epoch)) | 2016-05-16          | full            | 4.7e+04   | 21        | 1.8        | 3.3e-08 | 20      |
 | date (coerce to float(epoch)) | 2016-05-16          | str             | 4.9e+04   | 20        | 1.9        | 2.7e-08 | 20      |
 | date (coerce to float(epoch)) | 2016-05-16          | bool            | 4.91e+04  | 20.4      | 1.86       | 2e-08   | 20      |
 | date (coerce to float(epoch)) | 1463371843          | full            | 3.6e+05   | 2.8       | 14         | 3.3e-09 | 20      |
 | date (coerce to float(epoch)) | abc                 | full            | 4.2e+05   | 2.4       | 16         | 3.3e-09 | 20      |
 | date (coerce to float(epoch)) | 1463371843          | str             | 4.7e+05   | 2.1       | 18         | 3.3e-09 | 20      |
 | int                           | a                   | full            | 5.8e+05   | 1.7       | 22         | 3.3e-09 | 20      |
 | str+2clause                   |                     | full            | 5.82e+05  | 1.72      | 22         | 8e-10   | 22      |
 | date (coerce to float(epoch)) | 1463371843          | bool            | 6e+05     | 1.7       | 23         | 3.3e-09 | 20      |
 | date (coerce to float(epoch)) | abc                 | str             | 7e+05     | 1.4       | 26         | 1.7e-09 | 20      |
 | int                           | 1                   | full            | 9.1e+05   | 1.1       | 34         | 1.7e-09 | 20      |
 | str+2clause                   | abc                 | full            | 1e+06     | 0.996     | 38         | 4.2e-10 | 20      |
 | date (coerce to float(epoch)) | abc                 | bool            | 1.05e+06  | 0.957     | 39.6       | 4.1e-10 | 21      |
 | int                           | a                   | str             | 1e+06     | 0.96      | 40         | 1.2e-09 | 21      |
 | str+2clause                   |                     | str             | 1.088e+06 | 0.9188    | 41.22      | 4.7e-11 | 20      |
 | str+2clause                   |                     | full            | 1.24e+06  | 0.804     | 47.1       | 3.7e-10 | 26      |
 | date (coerce to float(epoch)) |                     | full            | 1.247e+06 | 0.8018    | 47.24      | 3.4e-11 | 21      |
 | int                           |                     | full            | 1.248e+06 | 0.8016    | 47.25      | 3.5e-11 | 24      |
 | str+2clause                   | abc                 | str             | 1.272e+06 | 0.7861    | 48.18      | 1.2e-11 | 20      |
 | int                           | 1                   | str             | 1.4e+06   | 0.71      | 53         | 1.7e-09 | 20      |
 | int                           |                     | str             | 1.6e+06   | 0.62      | 61         | 7.9e-10 | 22      |
 | str+2clause                   |                     | str             | 1.63e+06  | 0.614     | 61.7       | 2.1e-10 | 20      |
 | date (coerce to float(epoch)) |                     | str             | 1.6e+06   | 0.61      | 62         | 8.3e-10 | 20      |
 | str+2clause                   | abc                 | bool            | 2.345e+06 | 0.4264    | 88.82      | 3.5e-11 | 31      |
 | int                           | a                   | bool            | 2.429e+06 | 0.4117    | 91.99      | 3.5e-11 | 20      |
 | int                           | 1                   | bool            | 2.49e+06  | 0.401     | 94.4       | 9.3e-11 | 20      |
 | str+2clause                   |                     | bool            | 2.62e+06  | 0.382     | 99.1       | 2.1e-10 | 20      |
 | date (coerce to float(epoch)) |                     | bool            | 3.25e+06  | 0.308     | 123        | 1.9e-10 | 26      |
 | str+2clause                   |                     | bool            | 3.29e+06  | 0.304     | 125        | 2.1e-10 | 20      |
 | int                           |                     | bool            | 3.313e+06 | 0.3018    | 125.5      | 1.1e-11 | 20      |
 +-------------------------------+---------------------+-----------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
