package Bencher::Scenario::DataSah::Validate;

our $DATE = '2016-05-15'; # DATE
our $VERSION = '0.04'; # VERSION

my $return_types = ['bool', 'str', 'full'];

our $scenario = {
    summary => 'Benchmark validation',
    participants => [
        {
            name => 'gen_validator',
            code_template => 'state $v = Data::Sah::gen_validator(<schema>, {return_type => <return_type>}); $v->(<data>)',
        },
    ],
    datasets => [
        {
            name => 'int',
            args => {
                schema => 'int',
                'data@' => [1, "a"],
                'return_type@' => $return_types,
            },
        },
        {
            name => 'str+2clause',
            args => {
                schema => ['str', min_len=>1, max_len=>5],
                'data@' => ["abc", ""],
                'return_type@' => $return_types,
            },
        },
    ],
};

1;
# ABSTRACT: Benchmark validation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::Validate - Benchmark validation

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::DataSah::Validate (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-05-15.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::Validate

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_validator (perl_code)

Code template:

 state $v = Data::Sah::gen_validator(<schema>, {return_type => <return_type>}); $v->(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * int

=item * str+2clause

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSah::Validate >>):

 +-------------+----------+-----------------+-------------+-----------+------------+---------+---------+
 | dataset     | arg_data | arg_return_type | rate (/s)   | time (ns) | vs_slowest | errors  | samples |
 +-------------+----------+-----------------+-------------+-----------+------------+---------+---------+
 | int         | a        | full            | 1.085e+06   | 922.1     | 1          | 4.6e-11 | 20      |
 | str+2clause |          | full            | 1.11e+06    | 904       | 1.02       | 4e-10   | 22      |
 | int         | 1        | full            | 1.64e+06    | 608       | 1.52       | 2.1e-10 | 20      |
 | str+2clause | abc      | full            | 1.7e+06     | 588       | 1.57       | 2.1e-10 | 20      |
 | int         | a        | str             | 2.2e+06     | 4.4e+02   | 2.1        | 8.3e-10 | 20      |
 | str+2clause |          | str             | 2.46e+06    | 406       | 2.27       | 1.9e-10 | 23      |
 | str+2clause | abc      | str             | 2.6e+06     | 3.9e+02   | 2.4        | 8.3e-10 | 20      |
 | int         | 1        | str             | 2.72e+06    | 367       | 2.51       | 2e-10   | 23      |
 | str+2clause | abc      | bool            | 4.47765e+06 | 223.332   | 4.12864    | 0       | 20      |
 | int         | 1        | bool            | 4.5e+06     | 2.2e+02   | 4.1        | 3.3e-10 | 32      |
 | int         | a        | bool            | 4.58e+06    | 219       | 4.22       | 1e-10   | 20      |
 | str+2clause |          | bool            | 5.04e+06    | 198       | 4.65       | 1.1e-10 | 23      |
 +-------------+----------+-----------------+-------------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
