package Bencher::Scenario::DataCSelWrapStruct::wrap_struct;

our $DATE = '2016-08-26'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark wrap_struct()',
    participants => [
        {fcall_template => 'Data::CSel::WrapStruct::wrap_struct(<data>)'},
    ],
    datasets => [
        {name => 'scalar', args => {data=>1}},
        {name => 'array1', args => {data=>[1]}},
        {name => 'array100', args => {data=>[1..100]}},
        {name => 'array1000', args => {data=>[1..1000]}},
        {name => 'hash1', args => {data=>{1=>1}}},
        {name => 'hash100', args => {data=>{ map {$_=>$_} 1..100 }}},
        {name => 'hash1000', args => {data=>{ map {$_=>$_} 1..1000 }}},
    ],
};

1;
# ABSTRACT: Benchmark wrap_struct()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataCSelWrapStruct::wrap_struct - Benchmark wrap_struct()

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::DataCSelWrapStruct::wrap_struct (from Perl distribution Bencher-Scenarios-DataCSelWrapStruct), released on 2016-08-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataCSelWrapStruct::wrap_struct

To run module startup overhead benchmark:

 % bencher --module-startup -m DataCSelWrapStruct::wrap_struct

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::CSel::WrapStruct> 0.001

=head1 BENCHMARK PARTICIPANTS

=over

=item * Data::CSel::WrapStruct::wrap_struct (perl_code)

Function call template:

 Data::CSel::WrapStruct::wrap_struct(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * scalar

=item * array1

=item * array100

=item * array1000

=item * hash1

=item * hash100

=item * hash1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataCSelWrapStruct::wrap_struct >>):

 #table1#
 +-----------+-----------+-----------+------------+---------+---------+
 | dataset   | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +-----------+-----------+-----------+------------+---------+---------+
 | hash1000  |       660 |    1.5    |        1   |   2e-06 |      20 |
 | array1000 |       970 |    1      |        1.5 | 2.7e-06 |      24 |
 | hash100   |      6800 |    0.15   |       10   | 6.4e-07 |      20 |
 | array100  |      9300 |    0.11   |       14   | 4.2e-07 |      21 |
 | hash1     |    180000 |    0.0056 |      270   |   2e-08 |      20 |
 | array1    |    270000 |    0.0038 |      400   | 6.7e-09 |      20 |
 | scalar    |    870000 |    0.0012 |     1300   | 1.7e-09 |      20 |
 +-----------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m DataCSelWrapStruct::wrap_struct --module-startup >>):

 #table2#
 +------------------------+-----------+------------------------+------------+---------+---------+
 | participant            | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +------------------------+-----------+------------------------+------------+---------+---------+
 | Data::CSel::WrapStruct |       9.1 |                    4.2 |        1   |   2e-05 |      21 |
 | perl -e1 (baseline)    |       4.9 |                    0   |        1.9 | 1.8e-05 |      20 |
 +------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataCSelWrapStruct>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DataCSelWrapStruct>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataCSelWrapStruct>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
