package Bencher::Scenario::CompleteUtil::complete_array_elem;

our $DATE = '2016-06-26'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark complete_array_elem()',
    modules => {
        'Complete::Util' => {version=>0.45},
        'Text::Levenshtein::XS' => {version=>0},
    },
    participants => [
        {
            name => 'prefix-noci-1000',
            code => sub {
                state $ary = do {
                    require Complete::Util;
                    my $ary = [];
                    for my $l1 (0..9) {
                        for my $l2 (0..9) {
                            for my $l3 (0..9) {
                                push @$ary, "aaa${l1}bbb${l2}ccc${l3}"; # 12char
                            }
                        }
                    }
                    $ary;
                };
                local $Complete::Common::OPT_CI = 0;
                local $Complete::Common::OPT_MAP_CASE = 0;
                #local $Complete::Common::OPT_WORD_MODE = 0; # should not been used, because normal prefix matching returns result
                #local $Complete::Common::OPT_CHAR_MODE = 0; # should not been used, because normal prefix matching returns result
                #local $Complete::Common::OPT_FUZZY     = 0; # should not been used, because normal prefix matching returns result
                Complete::Util::complete_array_elem(
                    word  => 'aaa9bbb9ccc9',
                    array => $ary,
                );
            },
        },
        {
            name => 'prefix-1000',
            code => sub {
                state $ary = do {
                    require Complete::Util;
                    my $ary = [];
                    for my $l1 (0..9) {
                        for my $l2 (0..9) {
                            for my $l3 (0..9) {
                                push @$ary, "aaa${l1}bbb${l2}ccc${l3}"; # 12char
                            }
                        }
                    }
                    $ary;
                };
                #local $Complete::Common::OPT_WORD_MODE = 0; # should not been used, because normal prefix matching returns result
                #local $Complete::Common::OPT_CHAR_MODE = 0; # should not been used, because normal prefix matching returns result
                #local $Complete::Common::OPT_FUZZY     = 0; # should not been used, because normal prefix matching returns result
                Complete::Util::complete_array_elem(
                    word  => 'aaa9bbb9ccc9',
                    array => $ary,
                );
            },
        },

        # note that wordmode, charmode, and fuzzy also does prefix matching

        {
            name => 'wordmode-1000',
            code => sub {
                state $ary = do {
                    require Complete::Util;
                    my $ary = [];
                    for my $l1 ('a'..'j') {
                        for my $l2 ('a'..'j') {
                            for my $l3 ('a'..'j') {
                                push @$ary, ($l1 x 3).'-'.($l2 x 3).'-'.($l3 x 3); # 12char
                            }
                        }
                    }
                    $ary;
                };
                #local $Complete::Common::OPT_WORD_MODE = 0;
                #local $Complete::Common::OPT_CHAR_MODE = 0; # should not been used, because normal prefix matching returns result
                #local $Complete::Common::OPT_FUZZY     = 0; # should not been used, because normal prefix matching returns result
                Complete::Util::complete_array_elem(
                    word  => 'j-j-j',
                    array => $ary,
                );
            },
        },
        {
            name => 'charmode-1000',
            code => sub {
                state $ary = do {
                    require Complete::Util;
                    my $ary = [];
                    for my $l1 (0..9) {
                        for my $l2 (0..9) {
                            for my $l3 (0..9) {
                                push @$ary, "aaa${l1}bbb${l2}ccc${l3}"; # 12char
                            }
                        }
                    }
                    $ary;
                };
                local $Complete::Common::OPT_WORD_MODE = 0;
                #local $Complete::Common::OPT_CHAR_MODE = 0;
                #local $Complete::Common::OPT_FUZZY     = 0; # should not been used, because char-mode returns result
                Complete::Util::complete_array_elem(
                    word  => 'a9b9c9',
                    array => $ary,
                );
            },
        },
        {
            name => 'fuzzy-xs-1000',
            code => sub {
                state $ary = do {
                    require Complete::Util;
                    my $ary = [];
                    for my $l1 ('a'..'j') {
                        for my $l2 ('a'..'j') {
                            for my $l3 ('a'..'j') {
                                push @$ary, ($l1 x 4).($l2 x 4).($l3 x 4); # 12char
                            }
                        }
                    }
                    $ary;
                };
                local $Complete::Common::OPT_WORD_MODE = 0;
                local $Complete::Common::OPT_CHAR_MODE = 0;
                undef $Complete::Util::code_editdist;
                local $ENV{COMPLETE_UTIL_LEVENSHTEIN} = 'xs';
                Complete::Util::complete_array_elem(
                    word  => 'jjjjkjjjjjjj',
                    array => $ary,
                );
            },
        },
        {
            name => 'fuzzy-pp-1000',
            code => sub {
                state $ary = do {
                    require Complete::Util;
                    my $ary = [];
                    for my $l1 ('a'..'j') {
                        for my $l2 ('a'..'j') {
                            for my $l3 ('a'..'j') {
                                push @$ary, ($l1 x 4).($l2 x 4).($l3 x 4); # 12char
                            }
                        }
                    }
                    $ary;
                };
                local $Complete::Common::OPT_WORD_MODE = 0;
                local $Complete::Common::OPT_CHAR_MODE = 0;
                undef $Complete::Util::code_editdist;
                local $ENV{COMPLETE_UTIL_LEVENSHTEIN} = 'pp';
                Complete::Util::complete_array_elem(
                    word  => 'jjjjkjjjjjjj',
                    array => $ary,
                );
            },
        },
        {
            name => 'fuzzy-pp-100',
            code => sub {
                state $ary = do {
                    require Complete::Util;
                    my $ary = [];
                    for my $l1 ('a'..'j') {
                        for my $l2 ('a'..'j') {
                            push @$ary, ($l1 x 6).($l2 x 6); # 12char
                        }
                    }
                    $ary;
                };
                local $Complete::Common::OPT_WORD_MODE = 0;
                local $Complete::Common::OPT_CHAR_MODE = 0;
                undef $Complete::Util::code_editdist;
                local $ENV{COMPLETE_UTIL_LEVENSHTEIN} = 'pp';
                Complete::Util::complete_array_elem(
                    word  => 'jjjjjkjjjjj',
                    array => $ary,
                );
            },
        },
    ],
    #datasets => [
    #],
};

1;
# ABSTRACT: Benchmark complete_array_elem()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::CompleteUtil::complete_array_elem - Benchmark complete_array_elem()

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::CompleteUtil::complete_array_elem (from Perl distribution Bencher-Scenarios-CompleteUtil), released on 2016-06-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m CompleteUtil::complete_array_elem

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Complete::Util> 0.46

L<Text::Levenshtein::XS> 0.503

=head1 BENCHMARK PARTICIPANTS

=over

=item * prefix-noci-1000 (perl_code)



=item * prefix-1000 (perl_code)



=item * wordmode-1000 (perl_code)



=item * charmode-1000 (perl_code)



=item * fuzzy-xs-1000 (perl_code)



=item * fuzzy-pp-1000 (perl_code)



=item * fuzzy-pp-100 (perl_code)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m CompleteUtil::complete_array_elem >>):

 +------------------+-----------+-----------+------------+----------+---------+
 | participant      | rate (/s) | time (ms) | vs_slowest |  errors  | samples |
 +------------------+-----------+-----------+------------+----------+---------+
 | fuzzy-pp-1000    |       4.9 |   200     |        1   |   0.0003 |      20 |
 | fuzzy-pp-100     |      37   |    27     |        7.6 | 2.9e-05  |      20 |
 | fuzzy-xs-1000    |     110   |     9.1   |       22   | 2.3e-05  |      20 |
 | wordmode-1000    |     800   |     1.2   |      160   | 6.2e-06  |      20 |
 | charmode-1000    |    1330   |     0.75  |      270   | 2.1e-07  |      20 |
 | prefix-1000      |    2830   |     0.354 |      573   | 1.6e-07  |      20 |
 | prefix-noci-1000 |    3600   |     0.277 |      730   | 4.6e-08  |      27 |
 +------------------+-----------+-----------+------------+----------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-CompleteUtil>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-CompleteUtil>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-CompleteUtil>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
