package Bencher::Scenario::ShellQuoteAny;

our $DATE = '2017-01-04'; # DATE
our $VERSION = '0.003'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark cross-platform shell quoting',
    participants => [
        {
            fcall_template=>'ShellQuote::Any::shell_quote(<cmd>)',
        },
        {
            fcall_template=>'PERLANCAR::ShellQuote::Any::shell_quote(@{<cmd>})',
        },
        {
            fcall_template=>'ShellQuote::Any::Tiny::shell_quote(<cmd>)',
        },
    ],
    datasets => [
        {name=>'empty0', args=>{cmd=>[]}},
        {name=>'empty1', args=>{cmd=>['']}},
        {name=>'cmd1', args=>{cmd=>['foo bar']}},
        {name=>'cmd5', args=>{cmd=>['foo', 'bar', 'baz', 'qux', 'quux']}},
    ],
};

1;
# ABSTRACT: Benchmark cross-platform shell quoting

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ShellQuoteAny - Benchmark cross-platform shell quoting

=head1 VERSION

This document describes version 0.003 of Bencher::Scenario::ShellQuoteAny (from Perl distribution Bencher-Scenario-ShellQuoteAny), released on 2017-01-04.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ShellQuoteAny

To run module startup overhead benchmark:

 % bencher --module-startup -m ShellQuoteAny

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<ShellQuote::Any> 0.03

L<PERLANCAR::ShellQuote::Any> 0.002

L<ShellQuote::Any::Tiny> 0.003

=head1 BENCHMARK PARTICIPANTS

=over

=item * ShellQuote::Any::shell_quote (perl_code)

Function call template:

 ShellQuote::Any::shell_quote(<cmd>)



=item * PERLANCAR::ShellQuote::Any::shell_quote (perl_code)

Function call template:

 PERLANCAR::ShellQuote::Any::shell_quote(@{<cmd>})



=item * ShellQuote::Any::Tiny::shell_quote (perl_code)

Function call template:

 ShellQuote::Any::Tiny::shell_quote(<cmd>)



=back

=head1 BENCHMARK DATASETS

=over

=item * empty0

=item * empty1

=item * cmd1

=item * cmd5

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m ShellQuoteAny >>):

 #table1#
 {dataset=>"cmd1"}
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                             | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | ShellQuote::Any::shell_quote            |    228000 |      4.38 |       1    | 1.6e-09 |      23 |
 | PERLANCAR::ShellQuote::Any::shell_quote |    230000 |      4.36 |       1.01 | 1.7e-09 |      20 |
 | ShellQuote::Any::Tiny::shell_quote      |    850000 |      1.2  |       3.7  | 1.7e-09 |      20 |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"cmd5"}
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                             | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | PERLANCAR::ShellQuote::Any::shell_quote |    145000 |      6.91 |        1   | 2.8e-09 |      28 |
 | ShellQuote::Any::shell_quote            |    150000 |      6.8  |        1   | 1.7e-08 |      20 |
 | ShellQuote::Any::Tiny::shell_quote      |    710000 |      1.4  |        4.9 | 5.3e-09 |      21 |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"empty0"}
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                             | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | ShellQuote::Any::shell_quote            |    723000 |      1380 |        1   | 3.9e-10 |      23 |
 | PERLANCAR::ShellQuote::Any::shell_quote |    750000 |      1300 |        1   |   5e-09 |      20 |
 | ShellQuote::Any::Tiny::shell_quote      |   1000000 |      1000 |        1.4 | 1.6e-09 |      22 |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+

 #table4#
 {dataset=>"empty1"}
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                             | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+
 | PERLANCAR::ShellQuote::Any::shell_quote |    370000 |       2.7 |        1   | 3.1e-09 |      23 |
 | ShellQuote::Any::shell_quote            |    380000 |       2.7 |        1   | 1.1e-08 |      20 |
 | ShellQuote::Any::Tiny::shell_quote      |    850000 |       1.2 |        2.3 | 2.1e-09 |      20 |
 +-----------------------------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ShellQuoteAny --module-startup >>):

 #table5#
 +----------------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+
 | participant                | proc_private_dirty_size (kB) | proc_rss_size (MB) | proc_size (MB) | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +----------------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+
 | ShellQuote::Any::Tiny      | 836                          | 3.9                | 20             |       8.5 |      3.3               |        1   | 3.1e-05 |      20 |
 | ShellQuote::Any            | 852                          | 3.9                | 20             |       8   |      2.8               |        1.1 | 3.2e-05 |      20 |
 | PERLANCAR::ShellQuote::Any | 976                          | 4.2                | 20             |       5.6 |      0.399999999999999 |        1.5 | 4.2e-05 |      20 |
 | perl -e1 (baseline)        | 880                          | 4.1                | 20             |       5.2 |      0                 |        1.7 | 1.9e-05 |      21 |
 +----------------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ShellQuoteAny>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ShellQuoteAny>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ShellQuoteAny>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
