package Bencher::Scenario::ListMoreUtils;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark List::MoreUtils::PP vs List::MoreUtils::XS',
    description => <<'_',

EARLY VERSION, ONLY A FEW FUNCTIONS HAVE BEEN BENCHMARKED.

_
    participants => [
        # uniq
        {
            tags => ['arg1'],
            fcall_template => 'List::MoreUtils::PP::uniq(@{<list>})',
        },
        {
            tags => ['arg1'],
            module => 'List::MoreUtils::XS',
            function => 'uniq',
            code_template => 'List::MoreUtils::uniq(@{<list>})',
        },

        # minmax
        {
            tags => ['arg1'],
            fcall_template => 'List::MoreUtils::PP::minmax(@{<list>})',
        },
        {
            tags => ['arg1'],
            module => 'List::MoreUtils::XS',
            function => 'minmax',
            code_template => 'List::MoreUtils::minmax(@{<list>})',
        },

        # first
        {
            tags => ['arg1'],
            module   => 'List::MoreUtils::PP',
            function => 'firstidx',
            code_template => 'List::MoreUtils::PP::firstidx(sub{$_==-1}, @{<list>})',
        },
        {
            tags => ['arg1'],
            module   => 'List::MoreUtils::XS',
            function => 'firstidx',
            code_template => 'List::MoreUtils::firstidx(sub{$_==-1}, @{<list>})',
        },
    ],

    datasets => [
        {
            name => 'num10',
            args => {
                list => [1..9,1],
            },
            include_participant_tags => ['arg1'],
        },
        {
            name => 'num100',
            args => {
                list => [1..99,1],
            },
            include_participant_tags => ['arg1'],
        },
        {
            name => 'num1000',
            args => {
                list => [1..999,1],
            },
            include_participant_tags => ['arg1'],
        },
    ],
};

1;
# ABSTRACT: Benchmark List::MoreUtils::PP vs List::MoreUtils::XS

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ListMoreUtils

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::ListMoreUtils (from Perl distribution Bencher-Scenario-ListMoreUtils), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ListMoreUtils

To run module startup overhead benchmark:

 % bencher --module-startup -m ListMoreUtils

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<List::MoreUtils::PP> 0.413

L<List::MoreUtils::XS> 0.413

=head1 BENCHMARK PARTICIPANTS

=over

=item * List::MoreUtils::PP::uniq (perl_code)

Function call template:

 List::MoreUtils::PP::uniq(@{<list>})



=item * List::MoreUtils::XS::uniq (perl_code)

Code template:

 List::MoreUtils::uniq(@{<list>})



=item * List::MoreUtils::PP::minmax (perl_code)

Function call template:

 List::MoreUtils::PP::minmax(@{<list>})



=item * List::MoreUtils::XS::minmax (perl_code)

Code template:

 List::MoreUtils::minmax(@{<list>})



=item * List::MoreUtils::PP::firstidx (perl_code)

Code template:

 List::MoreUtils::PP::firstidx(sub{$_==-1}, @{<list>})



=item * List::MoreUtils::XS::firstidx (perl_code)

Code template:

 List::MoreUtils::firstidx(sub{$_==-1}, @{<list>})



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+-------------------------------------------------------------------+------------+-----------+---------+---------+
 | seq | name                                                              | rate       | time      | errors  | samples |
 +-----+-------------------------------------------------------------------+------------+-----------+---------+---------+
 | 14  | {dataset=>"num1000",participant=>"List::MoreUtils::PP::firstidx"} | 2.46e+03   | 406μs     | 2.1e-07 | 20      |
 | 2   | {dataset=>"num1000",participant=>"List::MoreUtils::PP::uniq"}     | 3175.006   | 314.96μs  | 4.5e-11 | 27      |
 | 8   | {dataset=>"num1000",participant=>"List::MoreUtils::PP::minmax"}   | 4.02e+03   | 248μs     | 4.8e-07 | 20      |
 | 5   | {dataset=>"num1000",participant=>"List::MoreUtils::XS::uniq"}     | 4.04e+03   | 247μs     | 2.1e-07 | 20      |
 | 17  | {dataset=>"num1000",participant=>"List::MoreUtils::XS::firstidx"} | 2.022e+04  | 49.45μs   | 1.3e-08 | 20      |
 | 13  | {dataset=>"num100",participant=>"List::MoreUtils::PP::firstidx"}  | 23723.16   | 42.1529μs | 1.2e-11 | 20      |
 | 11  | {dataset=>"num1000",participant=>"List::MoreUtils::XS::minmax"}   | 2.8e+04    | 36μs      | 1.7e-07 | 20      |
 | 1   | {dataset=>"num100",participant=>"List::MoreUtils::PP::uniq"}      | 38128.4    | 26.2272μs | 1e-11   | 23      |
 | 7   | {dataset=>"num100",participant=>"List::MoreUtils::PP::minmax"}    | 38612      | 25.8987μs | 4.6e-11 | 20      |
 | 4   | {dataset=>"num100",participant=>"List::MoreUtils::XS::uniq"}      | 5.86e+04   | 17.1μs    | 2.7e-08 | 20      |
 | 16  | {dataset=>"num100",participant=>"List::MoreUtils::XS::firstidx"}  | 1.921e+05  | 5.205μs   | 1.6e-09 | 22      |
 | 12  | {dataset=>"num10",participant=>"List::MoreUtils::PP::firstidx"}   | 2e+05      | 5.1μs     | 2e-08   | 20      |
 | 0   | {dataset=>"num10",participant=>"List::MoreUtils::PP::uniq"}       | 2.7e+05    | 3.7μs     | 1.4e-09 | 28      |
 | 10  | {dataset=>"num100",participant=>"List::MoreUtils::XS::minmax"}    | 276010     | 3.62306μs | 1.1e-11 | 20      |
 | 6   | {dataset=>"num10",participant=>"List::MoreUtils::PP::minmax"}     | 3.0486e+05 | 3.2802μs  | 1.1e-11 | 20      |
 | 3   | {dataset=>"num10",participant=>"List::MoreUtils::XS::uniq"}       | 5.3356e+05 | 1.8742μs  | 1.1e-11 | 20      |
 | 15  | {dataset=>"num10",participant=>"List::MoreUtils::XS::firstidx"}   | 1.1e+06    | 0.907μs   | 4.1e-10 | 21      |
 | 9   | {dataset=>"num10",participant=>"List::MoreUtils::XS::minmax"}     | 1.66e+06   | 0.604μs   | 1e-09   | 20      |
 +-----+-------------------------------------------------------------------+------------+-----------+---------+---------+


Benchmark module startup overhead:

 +-----+---------------------+--------+-------------------+---------+---------+
 | seq | name                | time   | mod_overhead_time | errors  | samples |
 +-----+---------------------+--------+-------------------+---------+---------+
 | 2   | List::MoreUtils::XS | 12.6ms | 7.85ms            | 3.2e-05 | 20      |
 | 1   | List::MoreUtils::PP | 11ms   | 6ms               | 0.00019 | 20      |
 | 0   | perl -e1 (baseline) | 4.7ms  | 0ms               | 5.7e-05 | 22      |
 +-----+---------------------+--------+-------------------+---------+---------+

=head1 DESCRIPTION

EARLY VERSION, ONLY A FEW FUNCTIONS HAVE BEEN BENCHMARKED.


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ListMoreUtils>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ListMoreUtils>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ListMoreUtils>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
