package Bencher::Scenario::ListMoreUtils;

our $DATE = '2015-11-14'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    participants => [
        # uniq
        {
            tags => ['arg1'],
            fcall_template => 'List::MoreUtils::PP::uniq(@{<list>})',
        },
        {
            tags => ['arg1'],
            module => 'List::MoreUtils::XS',
            function => 'uniq',
            code_template => 'List::MoreUtils::uniq(@{<list>})',
        },

        # minmax
        {
            tags => ['arg1'],
            fcall_template => 'List::MoreUtils::PP::minmax(@{<list>})',
        },
        {
            tags => ['arg1'],
            module => 'List::MoreUtils::XS',
            function => 'minmax',
            code_template => 'List::MoreUtils::minmax(@{<list>})',
        },

        # first
        {
            tags => ['arg1'],
            module   => 'List::MoreUtils::PP',
            function => 'firstidx',
            code_template => 'List::MoreUtils::PP::firstidx(sub{$_==-1}, @{<list>})',
        },
        {
            tags => ['arg1'],
            module   => 'List::MoreUtils::XS',
            function => 'firstidx',
            code_template => 'List::MoreUtils::firstidx(sub{$_==-1}, @{<list>})',
        },
    ],

    datasets => [
        {
            name => 'num10',
            args => {
                list => [1..9,1],
            },
            include_participant_tags => ['arg1'],
        },
        {
            name => 'num100',
            args => {
                list => [1..99,1],
            },
            include_participant_tags => ['arg1'],
        },
        {
            name => 'num1000',
            args => {
                list => [1..999,1],
            },
            include_participant_tags => ['arg1'],
        },
    ],
};

1;
# ABSTRACT: Benchmark List::MoreUtils::PP vs List::MoreUtils::XS

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ListMoreUtils - Benchmark List::MoreUtils::PP vs List::MoreUtils::XS

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::ListMoreUtils (from Perl distribution Bencher-Scenario-ListMoreUtils), released on 2015-11-14.

=head1 SYNOPSIS

 % bencher -m ListMoreUtils [other options]...

=head1 DESCRIPTION

B<EARLY VERSION, ONLY A FEW FUNCTIONS HAVE BEEN BENCHMARKED>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ListMoreUtils>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ListMoreUtils>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ListMoreUtils>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
