package App::lcpan::Cmd::authorrels;

our $DATE = '2015-04-11'; # DATE
our $VERSION = '0.15'; # VERSION

use 5.010;
use strict;
use warnings;

require App::lcpan;

our %SPEC;

$SPEC{':package'} = {
    v => 1.1,
    summary => "'authorrels' command",
};

$SPEC{'handle_cmd'} = {
    v => 1.1,
    summary => 'List releases of an author',
    args => {
        %App::lcpan::common_args,
        %App::lcpan::author_args,
        %App::lcpan::flatest_args,
        %App::lcpan::full_path_args,
    },
    result_naked=>1,
};
sub handle_cmd {
    my %args = @_;

    App::lcpan::list_local_cpan_releases(%args);
}

1;
# ABSTRACT: 'authorrels' command

__END__

=pod

=encoding UTF-8

=head1 NAME

App::lcpan::Cmd::authorrels - 'authorrels' command

=head1 VERSION

This document describes version 0.15 of App::lcpan::Cmd::authorrels (from Perl distribution App-lcpan), released on 2015-04-11.

=head1 FUNCTIONS


=head2 handle_cmd(%args) -> any

List releases of an author.

Arguments ('*' denotes required arguments):

=over 4

=item * B<author>* => I<str>

=item * B<cpan> => I<str>

Location of your local CPAN mirror, e.g. /path/to/cpan.

Defaults to C<~/cpan>.

=item * B<full_path> => I<bool>

=item * B<index_name> => I<str> (default: "index.db")

Filename of index.

=item * B<latest> => I<bool>

=back

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-lcpan>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-lcpan>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-lcpan>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
