use strict;
use warnings;
use ExtUtils::MakeMaker 6.64;	# 6.64 for TEST_REQUIRES
use Getopt::Long;	# Technique inspired by IO::Lambda
use IO::Socket::INET;

my $online_tests;

if($ENV{RELEASE_TESTING}) {
	$online_tests = are_online();
} elsif($ENV{AUTOMATED_TESTING} || $ENV{NO_NETWORK_TESTING}) {
	$online_tests = 0;
} else {
	Getopt::Long::GetOptions('online-tests!' => \$online_tests);

	if(!defined($online_tests)) {
		$online_tests = are_online();
	}
}

my $test_requires = {
	'Test::Most' => 0,
	'Test::NoWarnings' => 0,
};

if($online_tests) {
	open(my $enabled, '>', 't/online.enabled') || die "Can't touch t/online.enabled $!";
	close($enabled) || die "Can't touch t/online.enabled $!";
	# $test_requires->{'Geo::Coder::Google::V3'} = 0.10;
	$test_requires->{'Geo::Coder::OSM'} = 0;
	$test_requires->{'Geo::Coder::CA'} = 0;
	$test_requires->{'Geo::Coder::GeocodeFarm'} = 0;
	$test_requires->{'Geo::Coder::Ovi'} = 0;
	$test_requires->{'Geo::Coder::Postcodes'} = 0;
	# $test_requires->{'Geo::Coder::XYZ'} = 0.06;
	$test_requires->{'Test::Number::Delta'} = 0;
	$test_requires->{'Test::LWP::UserAgent'} = 0;
	$test_requires->{'Test::Carp'} = 0;
	$test_requires->{'LWP::UserAgent::Throttled'} = 0.04;
} else {
	unlink('t/online.enabled');
}

WriteMakefile(
    NAME		=> 'Geo::Coder::List',
    AUTHOR		=> q{Nigel Horne <njh@bandsman.co.uk>},
    VERSION_FROM	=> 'lib/Geo/Coder/List.pm',
    ABSTRACT_FROM       => 'lib/Geo/Coder/List.pm',
    ((defined($ExtUtils::MakeMaker::VERSION) &&
     ($ExtUtils::MakeMaker::VERSION >= 6.3002))
      ? ('LICENSE'=> 'GPL')
      : ()),
    PL_FILES	=> {},
    TEST_REQUIRES => $test_requires,
    PREREQ_PM => {
	'Carp' => 0,
	'LWP::Protocol::https' => 0,
	'Time::HiRes' => 0,
    },
    dist		=> { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean		=> { FILES => 'Geo::Coder::List-*' },
    META_MERGE		=> {
    	'meta-spec' => { version => 2 },
    	resources => {
    		repository => {
			type => 'git',
			url => 'git://github.com/nigelhorne/Geo-Coder-List.git',
			web => 'https://github.com/nigelhorne/Geo-Coder-List',
    		},
		bugtracker => {
			web => 'https://rt.cpan.org/Public/Dist/Display.html?Name=Geo-Coder-List',
			mailto => 'bug-Geo-Coder-List@rt.cpan.org'
		}
	},
    },
    MIN_PERL_VERSION	=> '5.6.2'	# Probably would work, but never tested on earlier versions than this
);

sub are_online
{
	my $s = IO::Socket::INET->new(
		PeerAddr => 'geocode.xyz:443',
		Timeout => 10
	);
	if($s) {
		print <<EOF;

You appear to be directly connected to the Internet.  I have some tests
that try to query various geocode services.

EOF
		close($s);

		# Timeout inspired by Mail::IMAPClient
		my $rc;
		eval {
			local $SIG{ALRM} = sub { die "alarm\n" };
			alarm(60);
			$rc = prompt('Do you want to enable these tests?', 'y') =~ /^y/i ? 1 : 0;
			alarm(0);
		};
		if($@) {
			print "\n";
			return 1;	# The default is 'y'
		}
		return $rc;
	} else {
		print "On-line tests disabled because I couldn't detect an Internet connexion\n";
		return 0;
	}
}
