
use ExtUtils::testlib;
use Test::More no_plan;
BEGIN { use_ok('Net::Address::Ethernet', qw( :all ), ) };

# Make sure the get_address() function was imported:
eval { my $s = get_address };
is($@, '');
# Make sure the method() function was imported:
eval { my $s = method };
is($@, '');

# Low-level tests of basic functionality:
ok(! is_address(undef));
ok(! is_address(''));
ok(! is_address('not an address'));
ok(is_address('1:2:3:a:b:c'));
ok(is_address('1:22:3:a:Bb:C'));
ok(is_address('01:20:03:0a:0b:0c'));
ok(is_address('11:22:33:aa:bb:cc'));
ok(is_address('11:22:33:AA:BB:CC'));
ok(is_address('11,22.33 A/BB;C'));
is(canonical(undef), '');
is(canonical(''), '');
is(canonical('not a number'), '');
is(canonical('1:2:3:a:B:c'), '01:02:03:0A:0B:0C');
is(canonical('1:22:3:a:bb:c'), '01:22:03:0A:BB:0C');
is(canonical('11:22:33:aa:Bb:CC'), '11:22:33:AA:BB:CC');
is(canonical('1-2-3-a-B-c'), '01:02:03:0A:0B:0C');
is(canonical('1 22 3 a bb c'), '01:22:03:0A:BB:0C');
is(canonical('11;22,3 aa.Bb/CC'), '11:22:03:AA:BB:CC');
