# A template for Makefile.PL.
# - Set the $PACKAGE variable to the name of your module.
# - Set $LAST_API_CHANGE to reflect the last version you changed the API 
#   of your module.
# - Fill in your dependencies in PREREQ_PM
# Alternatively, you can say the hell with this and use h2xs.

use 5.00503;

use lib qw(lib);    # build ourself with ourself
use ExtUtils::MakeMaker;

$PACKAGE = 'ExtUtils::MakeMaker';
($PACKAGE_FILE = $PACKAGE) =~ s|::|/|g;
$LAST_API_CHANGE = 5.50;

eval "require $PACKAGE";

unless ($@) { # Make sure we did find the module.
    print <<"CHANGE_WARN" if ${$PACKAGE.'::VERSION'} < $LAST_API_CHANGE;

NOTE: There have been API changes between this version and any older
than version $LAST_API_CHANGE!  Please read the Changes file if you
are upgrading from a version older than $LAST_API_CHANGE.

CHANGE_WARN
}

WriteMakefile(
    NAME            => $PACKAGE,
    VERSION_FROM    => "lib/$PACKAGE_FILE.pm", # finds $VERSION
    PREREQ_PM       => { File::Spec         => 0.8,
                         File::Basename     => 0,
                         DirHandle          => 0,
                       },
    INSTALLDIRS     => 'perl',
    EXE_FILES       => [qw(bin/instmodsh)],
);


{
    package MY;

    use File::Spec;

    my($lib, $tlib);
    BEGIN { 
        $lib  = File::Spec->rel2abs('lib/'); 
        $tlib = File::Spec->rel2abs('t/lib/');
    }

    # Make sure PERLRUN uses the MakeMaker about to be installed
    # and not the currently installed one.
    sub init_PERL {
        my($self) = shift;
        $self->SUPER::init_PERL;
        $self->{PERLRUN} .= qq{ "-I$lib"};
        $self->{FULLPERLRUN} .= qq{ "-I$lib"};
    }

    use Config;
    sub test_via_harness {
        my($self, $orig_perl, $tests) = @_;

        my @perls = ($orig_perl);
        if( $ENV{PERL_TEST_ALL} ) {
            push @perls, map "PERL5LIB=$lib /usr/local/bin/$_", 
              qw(bleadperl
                 perl5.6.1
                 perl5.6.0
                );
            push @perls, 
              map "PERL5LIB=$lib$Config{path_sep}$tlib /usr/local/bin/$_", 
                'perl5.005_03';
        }

        my $out;
        foreach my $perl (@perls) {
            $out .= $self->SUPER::test_via_harness($perl, $tests);
        }

        return $out;
    }
}
