/*
 * Decompiled with CFR 0.152.
 */
package jcckit.graphic;

import jcckit.util.ConfigParameters;
import jcckit.util.FactoryException;

public class Anchor {
    public static final Anchor LEFT_BOTTOM = new Anchor(0);
    public static final Anchor CENTER = new Anchor(1);
    public static final Anchor RIGHT_TOP = new Anchor(2);
    private static final String LEFT_VALUE = "left";
    private static final String RIGHT_VALUE = "right";
    private static final String CENTER_VALUE = "center";
    private static final String TOP_VALUE = "top";
    private static final String BOTTOM_VALUE = "bottom";
    private final int _factor;

    public static Anchor getHorizontalAnchor(ConfigParameters configParameters, String string, Anchor anchor) {
        Anchor anchor2 = anchor;
        String string2 = configParameters.get(string, null);
        if (string2 != null) {
            if (string2.equals(LEFT_VALUE)) {
                anchor2 = LEFT_BOTTOM;
            } else if (string2.equals(CENTER_VALUE)) {
                anchor2 = CENTER;
            } else if (string2.equals(RIGHT_VALUE)) {
                anchor2 = RIGHT_TOP;
            } else {
                throw new FactoryException(configParameters, string, "Invalid horizontal anchor.");
            }
        }
        return anchor2;
    }

    public static Anchor getVerticalAnchor(ConfigParameters configParameters, String string, Anchor anchor) {
        Anchor anchor2 = anchor;
        String string2 = configParameters.get(string, null);
        if (string2 != null) {
            if (string2.equals(BOTTOM_VALUE)) {
                anchor2 = LEFT_BOTTOM;
            } else if (string2.equals(CENTER_VALUE)) {
                anchor2 = CENTER;
            } else if (string2.equals(TOP_VALUE)) {
                anchor2 = RIGHT_TOP;
            } else {
                throw new FactoryException(configParameters, string, "Invalid vertcal anchor.");
            }
        }
        return anchor2;
    }

    private Anchor(int n) {
        this._factor = n;
    }

    public int getFactor() {
        return this._factor;
    }
}

