#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More tests => 1;

my @commits = split /\n/, <<'EOC';
37a5e17 PERL-507 deprecate get_collection on Collection
ff6a2d6 PERL-510 documented MongoDB::QueryResult
d7ce983 PERL-464 deprecate last_error method
1e33a0e PERL-497 remove use_boolean global
436d5c3 PERL-480 Fix GridFS assertion for corrupt files
1acd6e6 PERL-502, PERL-503: implement new CRUD API
969f036 PERL-503 distinct method and op
922e2d4 PERL-503 count method
61c2ba6 PERL-503 aggregate method
33575e8 PERL-503 check arguments to find
2216073 PERL-502 implement find_one_and_update
4fee454 PERL-502 implement find_one_and_replace
f383de5 PERL-502 implement find_one_and_delete
01a0fa3 PERL-502 implement bulk_write
b2d5527 PERL-502 implement update_many
b817140 PERL-502 implement update_one
4edb4be PERL-502 implement replace_one
84cb86d PERL-502 implement delete_many
236ae41 PERL-502 implement delete_one
556fba7 PERL-502 implement insert_one

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my @content = grep { /^v0.999.998.4(?:\s+|$)/ ... /^\S/ } <$fh>;

# drop the version line
shift @content;

# drop unindented last line and trailing blank lines
pop @content while ( @content && $content[-1] =~ /^(?:\S|\s*$)/ );

my $changelog = join(" ", @content);

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}
