CREATE TABLE change_deltas (
    id INTEGER NOT NULL PRIMARY KEY,
    change_id INTEGER NOT NULL UNIQUE,
    new INTEGER,
    action_format VARCHAR NOT NULL,
    action_node_id_1 INTEGER,
    action_node_id_2 INTEGER,
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE,
    FOREIGN KEY(action_node_id_1) REFERENCES nodes(id)
        ON DELETE CASCADE,
    FOREIGN KEY(action_node_id_2) REFERENCES nodes(id)
        ON DELETE CASCADE
);

CREATE TRIGGER
    change_deltas_ai_1
AFTER INSERT ON
    change_deltas
FOR EACH ROW WHEN
    NEW.new = 1
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.action_node_id_1,
        NEW.action_node_id_2
    );

    UPDATE
        changes
    SET
        ucount = ucount + 1,
        action = (
            SELECT
                printf(NEW.action_format, n1.id, n2.id)
            FROM
                (SELECT 1)
            LEFT JOIN
                nodes n1
            ON
                n1.id = NEW.action_node_id_1
            LEFT JOIN
                nodes n2
            ON
                n2.id = NEW.action_node_id_2
        )
    WHERE
        id = NEW.change_id
    ;


END;
