CREATE TABLE func_new_work(
    node_id INTEGER NOT NULL,
    change_id INTEGER NOT NULL,
    offset INTEGER NOT NULL,
    start INTEGER NOT NULL,
    stop INTEGER NOT NULL,
    comment TEXT,
    bill BOOL NOT NULL
);


CREATE TRIGGER
    func_new_work_bi_1
AFTER INSERT ON
    func_new_work
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.node_id,
        NEW.offset,
        NEW.start,
        NEW.stop,
        NEW.comment,
        NEW.bill
    );

    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_work' || x'0A'
                || '  bill: ' || NEW.bill || x'0A'
                ||
                    CASE WHEN
                        NEW.comment IS NULL
                    THEN
                        '  comment: ~' || x'0A'
                    WHEN
                        NEW.comment = '-'
                    THEN
                        '  comment: ''-''' || x'0A'
                    WHEN
                        instr(NEW.comment, x'0A') OR
                        instr(NEW.comment, '\\')
                    THEN
                        '  comment: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.comment, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.comment, ' ') OR
                        NEW.comment = '' -- not at all sufficient
                    THEN
                        '  comment: ''' || NEW.comment || '''' || x'0A'
                    ELSE
                        '  comment: ' || NEW.comment || x'0A'
                    END
                || '  node_uuid: ' || n.uuid || x'0A'
                || '  offset: ' || NEW.offset || x'0A'
                || '  start: ' || NEW.start || x'0A'
                || '  stop: ' || NEW.stop || x'0A'
            FROM
                nodes n
            WHERE
                n.id = NEW.node_id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_work'
    );

    INSERT INTO
        work_deltas(
            id,
            change_id,
            node_id,
            offset,
            start,
            stop,
            comment,
            bill
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.node_id,
        NEW.offset,
        NEW.start,
        NEW.stop,
        NEW.comment,
        NEW.bill
    );

    SELECT RAISE(IGNORE);
END;
