CREATE TABLE func_import_new_project_status(
    project_uuid VARCHAR(40) NOT NULL,
    status VARCHAR(40) NOT NULL,
    rank INTEGER NOT NULL,
    bill BOOL NOT NULL,
    uuid VARCHAR(40) NOT NULL
);


CREATE TRIGGER
    func_import_new_project_status_bi_1
BEFORE INSERT ON
    func_import_new_project_status
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.project_uuid,
        NEW.status,
        NEW.rank,
        NEW.bill,
        NEW.uuid
    );

    INSERT INTO
        func_new_project_status(
            change_id,
            id,
            project_id,
            status,
            rank,
            bill,
            uuid
        )
    SELECT
        currval('changes'),
        nextval('nodes'),
        p.id,
        NEW.status,
        NEW.rank,
        NEW.bill,
        NEW.uuid
    FROM
        nodes p
    WHERE
        p.uuid = NEW.project_uuid
    ;

    SELECT RAISE(IGNORE);
END;
