
use strict;
use warnings;

use 5.006;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Mashes up MooseX::Getopt and App::Cmd",
  "AUTHOR" => "Yuval Kogman <nothingmuch\@woobling.org>, Guillermo Roditi <groditi\@cpan.org>, Daisuke Maki <dmaki\@cpan.org>, Vladimir Timofeev <vovkasm\@gmail.com>, Bruno Vecchi <brunov\@cpan.org>, Offer Kaye <offerk\@cpan.org>, Mark Gardner <mjgardner\@cpan.org>, Yanick Champoux <yanick+cpan\@babyl.dyndns.org>, Dann <techmemo\@gmail.com>, Ken Crowell <oeuftete\@gmail.com>, Michael Joyce <ubermichael\@gmail.com>",
  "BUILD_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "MooseX-App-Cmd",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "MooseX::App::Cmd",
  "PREREQ_PM" => {
    "Any::Moose" => 0,
    "App::Cmd" => "0.321",
    "App::Cmd::Command" => 0,
    "English" => 0,
    "File::Basename" => 0,
    "Getopt::Long::Descriptive" => "0.091",
    "Mouse" => 0,
    "Test::use::ok" => 0,
    "namespace::clean" => 0
  },
  "TEST_REQUIRES" => {
    "Carp" => 0,
    "Data::Dumper" => 0,
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Moose" => 0,
    "Scalar::Util" => 0,
    "Test::More" => "0.94",
    "Test::Output" => 0,
    "YAML" => 0,
    "base" => 0,
    "lib" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "VERSION" => "0.20",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "Any::Moose" => 0,
  "App::Cmd" => "0.321",
  "App::Cmd::Command" => 0,
  "Carp" => 0,
  "Data::Dumper" => 0,
  "English" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Basename" => 0,
  "File::Spec" => 0,
  "Getopt::Long::Descriptive" => "0.091",
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Moose" => 0,
  "Mouse" => 0,
  "Scalar::Util" => 0,
  "Test::More" => "0.94",
  "Test::Output" => 0,
  "Test::use::ok" => 0,
  "YAML" => 0,
  "base" => 0,
  "lib" => 0,
  "namespace::clean" => 0,
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



