use ExtUtils::MakeMaker;
use Config;
use IO::File;

$VERSION = "0.12";

$fversion = $VERSION;
$fversion =~ s/\./_/og;

# incantation to enable MY::pm_to_blib later on
if ($^O eq 'MSWin32')
{
    push(@ExtUtils::MakeMaker::Overridable, qw(pm_to_blib));
    @extras = (dist => { 'TO_UNIX' => 'perl -Mtounix -e "tounix(\"$(DISTVNAME)\")"' });
}

@scripts = grep {-f && !m/\./o && !m/~$/o } glob("scripts/*");
@scripts = grep {!m|/add[^_]|oi} @scripts unless ($^O eq 'MSWin32');

@theselibs = grep {-f } glob("lib/Font/Scripts/*");

$perlbin = $Config{'sitebin'};
$fhi = IO::File->new("< FontUtils.isb") || die "Can't find FontUtils.isb";
$fho = IO::File->new("> FontUtils.iss") || die "Can't find FontUtils.iss";

$fho->print(<<'EOT');
; Don't edit me, edit FontUtils.isb. I'm autogenerated from that file

EOT
while (<$fhi>)
{
    s/{perl:\s*(.*?)\s*}/$1/oigee;
    $fho->print($_);
}
$fhi->close;
$fho->close;
    
WriteMakefile (
        NAME => "Font::TTF::Scripts",
        VERSION => $VERSION,
        EXE_FILES => \@scripts,
#        HTMLLIBPODS => {map {my $t = $_; $t=~s/\..*?$/.html/o; $t='blib/Html/'.$t; $_ => $t;} @theselibs},
#        HTMLSCRIPTPODS => {map {my $t=$_; $t=~s/\..*?$/.html/o; $t='blib/Html/'.$t; $_ => $t;} @scripts},
        AUTHOR => "martin_hosken\@sil.org",
        ABSTRACT => "TTF font support scripts for Perl",
		PREREQ_PM => {
			'Algorithm::Diff' => 0,
			'Font::TTF' => 0.44,
			'Text::PDF::File' => 0,
            'XML::Parser' => 0
			},
        @extras
    );

if ($^O eq 'MSWin32') {
# incantation to solve the problem of everyone's $Config{make} being 'nmake'
# when we want 'pmake'. And $Config{} is read only.
# actually, this is just a copy of the code from ExtUtiles::MM_Win32 tidied
# up (to expose tabs) and the dependency on Config removed
sub MY::pm_to_blib
{
    my $self = shift;
    my($autodir) = $self->catdir('$(INST_LIB)','auto');
    return <<"EOT";

pm_to_blib: \$(TO_INST_PM)
\t$self->{NOECHO}\$(PERL) \"-I\$(INST_ARCHLINE)\" \"-I\$(INST_LIB)\" \\
\t\"-I\$(PERL_ARCHLIB)\" \"-I\$(PERL_LIB)\" -MExtUtils::Install \\
\t-e \"pm_to_blib({ qw[\$(PM_TO_BLIB)] }, '$autodir')
\t$self->{NOECHO}\$(TOUCH) \$@

EOT
}

}

sub MY::postamble
{
    my (@files) = map {m|scripts/(.*)$|o; $1;} @scripts;
    my ($res, $fh, $files);
    
    $files = join (' ', grep {$_ ne 'addpath'} @files);
    $files =~ s/addpath\.bat\s*//o;     # remove addpath since don't need a .bat
    $fh = IO::File->new("> addbats.pl") || die "Can't create addbats.pl";
    
    $fh->print(<<"EOT");
#! perl
foreach \$f (qw($files))
{
    if (\$ARGV[0] eq '-r')
    {
        unlink "\$ARGV[1]\\\\\$f.bat";
    }
    else
    {
        open(FH, "> \$ARGV[0]\\\\\$f.bat") || die \$@;
        print FH "\@\\"\$ARGV[0]\\\\parl.exe\\" \\"\$ARGV[0]\\\\fontutils.par\\" \$f %1 %2 %3 %4 %5 %6 %7 %8 %9\\n";
        close(FH);
    }
}
EOT
    $fh->close();
    
    push (@scripts, "addbats.pl");

	if ($^O eq 'MSWin32')
	{
		require Win32::TieRegistry;
		Win32::TieRegistry->import (Delimiter=>"/") ;
		$compile = $Registry->{'Classes/InnoSetupScriptFile/shell/Compile/command//'};
		$compile =~ s/\s*"?%1"?.*$//;
		$compile = "start \"compile\" /wait $compile";
	}

    $res .= "exe : TTFontUtils_$fversion.exe\n\n";

    $res .= "TTFontUtils_$fversion.exe : scripts\\fontutils.par\n";
    $res .= "\t$compile FontUtils.iss\n\n";
    
    $res .= "scripts\\fontutils.par : ";
    $res .= join(' ', @scripts);
    $res .= "\n\tpp -B -p -o scripts\\fontutils.par -M Font::TTF::Useall " . join(' ', @scripts);
    $res .= "\n\n";
    
    $res;
}

1;
