package Moose::Experiment;

use 5.006;
use Moose; # Automatically turns on strict and warnings
# Now this code is a Moose class
use DateTime;
use DataTime::Format::Natural;
use Moose::Util::TypeConstraints;

=head1 NAME
Mosse is a complete object system for Perl5. It provides keywords for
attribute declaration, object construction, inheritance and more.
Moose::Experiment - The great new Moose::Experiment! is for experiment
with Moose L<Moose|http://moose.iinteractive.com/en/> and 
L<Module::Starter|http://search.cpan.org/~xsawyerx/Module-Starter-1.71/
lib/Module/Starter.pm> in Perl5.

=head1 VERSION

Version 0.01_01

=cut

our $VERSION = '0.01_01';


=head1 SYNOPSIS

Quick summary of what the module does.

Perhaps a little code snippet.

    use Moose::Experiment;

    my $foo = Moose::Experiment->new();
    ...

=head1 EXPORT

A list of functions that can be exported.  You can delete this section
if you don't export anything, such as for a purely object-oriented module.

=head1 ATTRIBUTE/SUBROUTINES/METHODS

=head2 ATTRIBUTE firstName
An attribute is a property of the class that defines it. It always has
a name, and it may have a number of other properties.
=cut

has 'firstName' => (
	is	=>	'rw',	# read/wright flag
	isa	=>	'Str',
	required	=>	1,
);
class_type 'DateTime';

my $en_parser = DateTime::Format::Natural->new(
	lang	=>	'en',
	time_zone	=>	'UTC',
	);

=head2 lastName

=cut

has 'lastName' => (
	is	=>	'rw',
	isa	=>	'Str',
);

=head1 METHOD login

=cut

sub login { ... }

=head1 METHOD MODIFIERS
modifiers come in different flavors like before, after, around, augument
and you can apply more then one modifier to a single method.
=cut

before 'login' => sub {
	my $self = shift;
	my $pw	 = shift;
	warm "called login() with $pw\n";
};

=head1 AUTHOR

Mihai Cornel, C<< <mhcrnl at gmail.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-moose-experiment at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Moose-Experiment>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.




=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Moose::Experiment


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Moose-Experiment>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Moose-Experiment>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Moose-Experiment>

=item * Search CPAN

L<http://search.cpan.org/dist/Moose-Experiment/>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

Copyright 2015 Mihai Cornel.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


=cut

1; # End of Moose::Experiment
