/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import org.openqa.selenium.server.DefaultSeleneseCommand;
import org.openqa.selenium.server.SeleneseCommand;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;
import org.openqa.selenium.server.SingleEntryAsyncQueue;

public class SeleneseQueue {
    private SingleEntryAsyncQueue commandHolder = new SingleEntryAsyncQueue();
    private SingleEntryAsyncQueue commandResultHolder = new SingleEntryAsyncQueue();

    public String doCommand(String command, String field, String value) {
        this.commandHolder.put(new DefaultSeleneseCommand(command, field, value));
        try {
            return (String)this.commandResultHolder.get();
        }
        catch (SeleniumCommandTimedOutException e) {
            return "ERROR: Command timed out";
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{ commandHolder=");
        sb.append(this.commandHolder.toString()).append(", ").append(" commandResultHolder=").append(this.commandResultHolder.toString()).append(" }");
        return sb.toString();
    }

    public SeleneseCommand handleCommandResult(String commandResult) {
        if (commandResult != null) {
            this.commandResultHolder.put(commandResult);
        }
        SeleneseCommand sc = (SeleneseCommand)this.commandHolder.get();
        return sc;
    }
}

