/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.server.SeleneseQueue;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.DestroyableRuntimeExecutingBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.HTABrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.InternetExplorerCustomProxyLauncher;
import org.openqa.selenium.server.browserlaunchers.OperaCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.SafariCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.SeleneseQueueAware;

public class BrowserLauncherFactory {
    private static final Pattern CUSTOM_PATTERN = Pattern.compile("^\\*custom( .*)?$");
    private static final Map supportedBrowsers = new HashMap();
    SeleniumServer server;

    public BrowserLauncherFactory(SeleniumServer server) {
        this.server = server;
    }

    public BrowserLauncher getBrowserLauncher(String browser, String sessionId, SeleneseQueue queue) {
        if (browser == null) {
            throw new IllegalArgumentException("browser may not be null");
        }
        Iterator iterator = supportedBrowsers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Class c = (Class)entry.getValue();
            Pattern pat = Pattern.compile("^\\*" + name + "( .*)?$");
            Matcher mat = pat.matcher(browser);
            if (!mat.find()) continue;
            String browserStartCommand = browser.equals("*" + name) ? null : mat.group(1).substring(1);
            return this.createBrowserLauncher(c, browserStartCommand, sessionId, queue);
        }
        Matcher CustomMatcher = CUSTOM_PATTERN.matcher(browser);
        if (CustomMatcher.find()) {
            String browserStartCommand = CustomMatcher.group(1).substring(1);
            return new DestroyableRuntimeExecutingBrowserLauncher(browserStartCommand, sessionId);
        }
        throw this.browserNotSupported(browser);
    }

    public void addBrowserLauncher(String browser, Class clazz) {
        supportedBrowsers.put(browser, clazz);
    }

    private RuntimeException browserNotSupported(String browser) {
        StringBuffer errorMessage = new StringBuffer("Browser not supported: " + browser);
        errorMessage.append('\n');
        if (!browser.startsWith("*")) {
            errorMessage.append("(Did you forget to add a *?)\n");
        }
        errorMessage.append('\n');
        errorMessage.append("Supported browsers include:\n");
        Iterator iterator = supportedBrowsers.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            errorMessage.append("  *").append(name).append('\n');
        }
        errorMessage.append("  *custom\n");
        return new RuntimeException(errorMessage.toString());
    }

    private BrowserLauncher createBrowserLauncher(Class c, String browserStartCommand, String sessionId, SeleneseQueue queue) {
        try {
            BrowserLauncher browserLauncher;
            if (null == browserStartCommand) {
                Constructor ctor = c.getConstructor(Integer.TYPE, String.class);
                Object[] args = new Object[]{new Integer(this.server.getPort()), sessionId};
                browserLauncher = (BrowserLauncher)ctor.newInstance(args);
            } else {
                Constructor ctor = c.getConstructor(Integer.TYPE, String.class, String.class);
                Object[] args = new Object[]{new Integer(this.server.getPort()), sessionId, browserStartCommand};
                browserLauncher = (BrowserLauncher)ctor.newInstance(args);
            }
            if (browserLauncher instanceof SeleneseQueueAware) {
                ((SeleneseQueueAware)((Object)browserLauncher)).setSeleneseQueue(queue);
            }
            return browserLauncher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        supportedBrowsers.put("firefox", FirefoxCustomProfileLauncher.class);
        supportedBrowsers.put("iexplore", InternetExplorerCustomProxyLauncher.class);
        supportedBrowsers.put("safari", SafariCustomProfileLauncher.class);
        supportedBrowsers.put("iehta", HTABrowserLauncher.class);
        supportedBrowsers.put("chrome", FirefoxChromeLauncher.class);
        supportedBrowsers.put("opera", OperaCustomProfileLauncher.class);
    }
}

