/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Delete;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.HTABrowserLauncher;

public class LauncherUtils {
    protected static File createCustomProfileDir(String sessionId) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String customProfileDirParent = tmpDir.exists() && tmpDir.isDirectory() ? tmpDir.getAbsolutePath() : ".";
        File customProfileDir = new File(customProfileDirParent + "/customProfileDir" + sessionId);
        if (customProfileDir.exists()) {
            LauncherUtils.recursivelyDeleteDir(customProfileDir);
        }
        customProfileDir.mkdir();
        return customProfileDir;
    }

    protected static void recursivelyDeleteDir(File customProfileDir) {
        Delete delete = new Delete();
        delete.setProject(new Project());
        delete.setDir(customProfileDir);
        delete.setFailOnError(true);
        delete.execute();
    }

    protected static void deleteTryTryAgain(File dir, int tries) {
        try {
            LauncherUtils.recursivelyDeleteDir(dir);
        }
        catch (BuildException e) {
            if (tries > 0) {
                AsyncExecute.sleepTight(2000L);
                LauncherUtils.deleteTryTryAgain(dir, tries - 1);
            }
            throw e;
        }
    }

    protected static File makeProxyPAC(File parentDir, int port) throws FileNotFoundException {
        File proxyPAC = new File(parentDir, "proxy.pac");
        PrintStream out = new PrintStream(new FileOutputStream(proxyPAC));
        out.println("function FindProxyForURL(url, host) {");
        out.println("   if(shExpMatch(url, '*/selenium-server/*')) {");
        out.println("       return 'PROXY localhost:" + Integer.toString(port) + "; DIRECT'");
        out.println("   }");
        out.println("}");
        out.close();
        return proxyPAC;
    }

    public static String stripStartURL(String url) {
        try {
            URL u = new URL(url);
            return u.getProtocol() + "://" + u.getAuthority();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getQueryString(String url) {
        try {
            URL u = new URL(url);
            String query = u.getQuery();
            return query;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getDefaultHTMLSuiteUrl(String browserURL, String suiteUrl) {
        String url = LauncherUtils.stripStartURL(browserURL);
        return url + "/selenium-server/core/TestRunner.html?auto=true&resultsUrl=../postResults&test=" + suiteUrl;
    }

    protected static String getDefaultRemoteSessionUrl(String startURL, String sessionId) {
        String url = LauncherUtils.stripStartURL(startURL);
        return url + "/selenium-server/core/SeleneseRunner.html?sessionId=" + sessionId;
    }

    protected static File extractHTAFile(File dir, int port, String resourceFile, String outFile) {
        InputStream input = HTABrowserLauncher.class.getResourceAsStream(resourceFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        File hta = new File(dir, outFile);
        try {
            FileWriter fw = new FileWriter(hta);
            String line = br.readLine();
            fw.write(line);
            fw.write(10);
            fw.write("<base href=\"http://localhost:" + port + "/selenium-server/core/\">");
            while ((line = br.readLine()) != null) {
                fw.write(line);
                fw.write(10);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hta;
    }
}

