/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.ResourceHandler;
import org.openqa.selenium.server.SeleneseCommand;
import org.openqa.selenium.server.SeleneseQueue;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;

public class SeleniumDriverResourceHandler
extends ResourceHandler {
    private final Map queues = new HashMap();
    private final Map launchers = new HashMap();
    private SeleniumServer server;

    public SeleniumDriverResourceHandler(SeleniumServer server) {
        this.server = server;
    }

    private String getParam(HttpRequest req, String name) {
        List parameterValues = req.getParameterValues(name);
        if (parameterValues == null) {
            return null;
        }
        return (String)parameterValues.get(0);
    }

    public void handle(String pathInContext, String pathParams, HttpRequest req, HttpResponse res) throws HttpException, IOException {
        res.setField("Content-Type", "text/plain");
        this.setNoCacheHeaders(res);
        OutputStream out = res.getOutputStream();
        ByteArrayOutputStream buf = new ByteArrayOutputStream(1000);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, "UTF-8");
        String seleniumStart = this.getParam(req, "seleniumStart");
        String method = req.getMethod();
        String cmd = this.getParam(req, "cmd");
        String sessionId = this.getParam(req, "sessionId");
        if ("POST".equalsIgnoreCase(method) || seleniumStart != null && seleniumStart.equals("true")) {
            int c;
            InputStream is = req.getInputStream();
            StringBuffer sb = new StringBuffer();
            InputStreamReader r = new InputStreamReader(is, "UTF-8");
            while ((c = r.read()) != -1) {
                sb.append((char)c);
            }
            String commandResult = sb.toString();
            if ("true".equals(seleniumStart)) {
                commandResult = null;
            }
            SeleneseQueue queue = this.getQueue(sessionId);
            SeleneseCommand sc = queue.handleCommandResult(commandResult);
            ((Writer)writer).flush();
            writer.write(sc.toString());
            int pad = 998 - buf.size();
            while (pad-- > 0) {
                writer.write(" ");
            }
            writer.write("\r\n");
            ((Writer)writer).flush();
            buf.writeTo(out);
            req.setHandled(true);
        } else if (cmd != null) {
            this.handleCommandRequest(req, res, cmd, sessionId);
        } else {
            req.setHandled(false);
        }
    }

    private void handleCommandRequest(HttpRequest req, HttpResponse res, String cmd, String sessionId) {
        res.setContentType("text/plain");
        this.hackRemoveConnectionCloseHeader(res);
        Vector<String> values = new Vector<String>();
        int i = 1;
        while (req.getParameter(Integer.toString(i)) != null) {
            values.add(req.getParameter(Integer.toString(i)));
            ++i;
        }
        if (values.size() < 1) {
            values.add("");
        }
        if (values.size() < 2) {
            values.add("");
        }
        System.out.println("queryString = " + req.getQuery());
        String results = this.doCommand(cmd, values, sessionId, res);
        try {
            res.getOutputStream().write(results.getBytes("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        req.setHandled(true);
    }

    public String doCommand(String cmd, Vector values, String sessionId, HttpResponse res) {
        String results;
        if ("getNewBrowserSession".equals(cmd)) {
            results = "OK," + this.getNewBrowserSession((String)values.get(0), (String)values.get(1));
        } else if ("testComplete".equals(cmd)) {
            BrowserLauncher launcher = this.getLauncher(sessionId);
            if (launcher == null) {
                results = "ERROR: No launcher found for sessionId " + sessionId;
            } else {
                launcher.close();
                if ("testComplete".equals(cmd)) {
                    this.clearQueue(sessionId);
                }
                results = "OK";
            }
        } else if ("shutDown".equals(cmd)) {
            System.out.println("Shutdown command received");
            if (res != null) {
                try {
                    res.getOutputStream().write("OK".getBytes());
                    res.commit();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            AsyncExecute.sleepTight(3000L);
            System.exit(0);
            results = null;
        } else if ("isPostSupported".equals(cmd)) {
            results = "OK,false";
        } else if ("addStaticContent".equals(cmd)) {
            File dir = new File((String)values.get(0));
            if (dir.exists()) {
                this.server.addNewStaticContent(dir);
                results = "OK";
            } else {
                results = "ERROR: dir does not exist - " + dir.getAbsolutePath();
            }
        } else if ("runHTMLSuite".equals(cmd)) {
            HTMLLauncher launcher = new HTMLLauncher(this.server);
            File output = null;
            if (values.size() < 3) {
                results = "ERROR: Not enough arguments (browser, browserURL, suiteURL, [outputFile])";
            } else {
                if (values.size() > 3) {
                    output = new File((String)values.get(3));
                }
                long timeout = 1800000L;
                try {
                    results = launcher.runHTMLSuite((String)values.get(0), (String)values.get(1), (String)values.get(2), output, timeout);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    results = e.toString();
                }
            }
        } else {
            SeleneseQueue queue = this.getQueue(sessionId);
            results = queue.doCommand(cmd, (String)values.get(0), (String)values.get(1));
        }
        System.out.println("Got result: " + results);
        return results;
    }

    private String getNewBrowserSession(String browser, String startURL) {
        if (browser == null) {
            throw new IllegalArgumentException("browser may not be null");
        }
        String sessionId = Long.toString(System.currentTimeMillis());
        BrowserLauncherFactory blf = new BrowserLauncherFactory(this.server);
        BrowserLauncher launcher = blf.getBrowserLauncher(browser, sessionId);
        launcher.launchRemoteSession(startURL);
        this.launchers.put(sessionId, launcher);
        SeleneseQueue queue = this.getQueue(sessionId);
        queue.doCommand("setContext", sessionId, "");
        String results = sessionId;
        return results;
    }

    private void hackRemoveConnectionCloseHeader(HttpResponse res) {
        res.removeField("Connection");
        Field[] fields = HttpConnection.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field _close;
            if (fields[i].getName().equals("_close")) {
                _close = fields[i];
                _close.setAccessible(true);
                try {
                    _close.setBoolean(res.getHttpConnection(), false);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (!fields[i].getName().equals("_persistent")) continue;
            _close = fields[i];
            _close.setAccessible(true);
            try {
                _close.setBoolean(res.getHttpConnection(), true);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrowserLauncher getLauncher(String sessionId) {
        Map map = this.launchers;
        synchronized (map) {
            return (BrowserLauncher)this.launchers.get(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SeleneseQueue getQueue(String sessionId) {
        Map map = this.queues;
        synchronized (map) {
            SeleneseQueue queue = (SeleneseQueue)this.queues.get(sessionId);
            if (queue == null) {
                queue = new SeleneseQueue();
                this.queues.put(sessionId, queue);
            }
            return queue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueue(String sessionId) {
        Map map = this.queues;
        synchronized (map) {
            this.queues.remove(sessionId);
        }
    }

    public void stopAllBrowsers() {
        Iterator i = this.launchers.values().iterator();
        while (i.hasNext()) {
            BrowserLauncher launcher = (BrowserLauncher)i.next();
            launcher.close();
        }
    }

    private void setNoCacheHeaders(HttpResponse res) {
        res.setField("Cache-Control", "no-cache");
        res.setField("Pragma", "no-cache");
        res.setField("Expires", "-1");
    }
}

