# Copyright: 2001-2003 The Perl Foundation.  All Rights Reserved.
# $Id: snprintf.pl 7613 2005-03-08 22:52:10Z bernhard $

=head1 NAME

config/auto/snprintf.pl - Test for snprintf

=head1 DESCRIPTION

Tests if snprintf is present and if it's C99 compliant.

=cut

package Configure::Step;

use strict;
use vars qw($description @args);

$description = "Testing snprintf ...";

@args = qw(verbose);

sub runstep {
  my ($verbose) = @_;
  cc_gen('config/auto/snprintf/test.in');
  cc_build();
  my $res = cc_run() or die "Can't run the snprintf testing program: $!";
  cc_clean();

  if ($res =~ /snprintf/) {
    Configure::Data->set(
      HAS_SNPRINTF => 1,
    );
  }
  if ($res =~ /^C99 snprintf/) {
    Configure::Data->set(
      HAS_C99_SNPRINTF => 1,
    );
  }
  elsif ($res =~ /^old snprintf/) {
    Configure::Data->set(
      HAS_OLD_SNPRINTF => 1,
    );
  }
  print " ($res) " if $verbose;
}

1;
