#! perl -w
# Copyright: 2001-2003 The Perl Foundation.  All Rights Reserved.
# $Id: parrot_config_c.pl 6807 2004-10-11 10:44:32Z leo $

=head1 NAME

build_tools/parrot_config_c.pl - Create parrot_config.c

=head1 SYNOPSIS

    % perl build_tools/parrot_config_c.pl > src/parrot_config.h

=head1 DESCRIPTION

Create F<src/parrot_config.h> with relevant runtime information like install
prefix.

=cut


use strict;
use lib 'lib';
use Parrot::Config;

my $prefix = $PConfig{'prefix'};
$prefix = "" unless defined $prefix;

print << "EOF";
/*
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *
 * This file is generated automatically by $0.
 *
 * Any changes made here will be lost!
 *
 */

static const char* runtime_prefix = \"$prefix\";

EOF


