package Bio::Palantir::Parser::Motif;
# ABSTRACT: BiosynML DTD-derived internal class
$Bio::Palantir::Parser::Motif::VERSION = '0.191800';
use Moose;
use namespace::autoclean;

# AUTOGENERATED CODE! DO NOT MODIFY THIS FILE!

use XML::Bare qw(forcearray);
use Data::UUID;

use aliased 'Bio::Palantir::Parser::Qualifier';
use aliased 'Bio::Palantir::Parser::Location';


# private attributes
has '_root' => (
    is       => 'ro',
    isa      => 'HashRef',
    required => 1,
);

has 'uui' => (
    is       => 'ro',
    isa      => 'Str',
    init_arg => undef,
    default  => sub {
        my $self = shift;
        my $ug = Data::UUID->new;
        my $uui = $ug->create_str();    
        return $uui;
    }
);

has 'rank' => (
    is      => 'ro',
    isa     => 'Num',
	default => -1,
	writer  => '_set_rank',
);


# public array(s) of composed objects


has 'qualifiers' => (
    traits   => ['Array'],
    is       => 'ro',
    isa      => 'ArrayRef[Bio::Palantir::Parser::Qualifier]',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_qualifiers',
    handles  => {
         count_qualifiers => 'count',
           all_qualifiers => 'elements',
           get_qualifier  => 'get',
          next_qualifier  => 'shift',        
        filter_qualifiers => 'grep',
    },
);


## no critic (ProhibitUnusedPrivateSubroutines)
sub _build_qualifiers {
    my $self = shift;
    return [ map { Qualifier->new( _root => $_ ) } @{
    forcearray $self->_root->{motif_qualifiers}->{qualifier}
    } ];
}


## use critic



# public composed object(s)


has 'locations' => (
    is       => 'ro',
    isa      => 'Bio::Palantir::Parser::Location',
    init_arg => undef,
    lazy     => 1,
    builder  => '_build_locations',
	handles  => {
		      genomic_dna_begin => 'dna_begin',
		        genomic_dna_end => 'dna_end',
		       genomic_dna_size => 'dna_size',
        genomic_dna_coordinates => 'dna_coordinates',
         genomic_prot_begin => 'prot_begin',
           genomic_prot_end => 'prot_end',
          genomic_prot_size => 'prot_size',
       genomic_prot_coordinates => 'prot_coordinates',
	},
);

## no critic (ProhibitUnusedPrivateSubroutines)

sub _build_locations {
    my $self = shift;
    return Location->new(
        _root => $self->_root->{motif_location}
    );
}

# use critic


# public deep methods


# public methods


sub name {
    return shift->_root->{'motif_name'}->{'value'} // 'NA'
}


sub type {
    return shift->_root->{'motif_type'}->{'value'} // 'NA'
}


sub sequence {
    return shift->_root->{'sequence'}->{'value'} // 'NA'
}



# public aliases


sub detail {
	my $detail;

	for my $qualifier(shift->_get_filtered_qualifiers('note')) {
		($detail) = $qualifier =~ m/ NRPS\/PKS \s Motif: \s (.*) /xms;
        last if $detail;
	}
	
	return $detail;
} 

sub _get_filtered_qualifiers {
    my $self = shift;
    my $pattern = shift;

    my (@filtered_qualifiers) 
        = $self->filter_qualifiers( sub { $_->name eq $pattern} );
    return map { $_->value } @filtered_qualifiers; 
}


__PACKAGE__->meta->make_immutable;
1;

__END__

=pod

=head1 NAME

Bio::Palantir::Parser::Motif - BiosynML DTD-derived internal class

=head1 VERSION

version 0.191800

=head1 SYNOPSIS

    # TODO

=head1 DESCRIPTION

    # TODO

=head1 ATTRIBUTES

=head2 qualifiers

ArrayRef of L<Bio::Palantir::Parser::Qualifier>

=head2 locations

L<Bio::Palantir::Parser::Location> composed object

=head1 METHODS

=head2 count_qualifiers

Returns the number of Qualifiers of the Motif.

    # $motif is a Bio::Palantir::Parser::Motif
    my $count = $motif->count_qualifiers;

This method does not accept any arguments.

=head2 all_qualifiers

Returns all the Qualifiers of the Motif (not an array reference).

    # $motif is a Bio::Palantir::Parser::Motif
    my @qualifiers = $motif->all_qualifiers;

This method does not accept any arguments.

=head2 get_qualifier

Returns one Qualifier of the Motif by its index. You can also use
negative index numbers, just as with Perl's core array handling. If the
specified Qualifier does not exist, this method will return C<undef>.

    # $motif is a Bio::Palantir::Parser::Motif
    my $qualifier = $motif->get_qualifier($index);
    croak "Qualifier $index not found!" unless defined $qualifier;

This method accepts just one argument (and not an array slice).

=head2 next_qualifier

Shifts the first Qualifier of the array off and returns it, shortening the
array by 1 and moving everything down. If there are no more Qualifiers in
the array, returns C<undef>.

    # $motif is a Bio::Palantir::Parser::Motif
    while (my $qualifier = $motif->next_qualifier) {
        # process $qualifier
        # ...
    }

This method does not accept any arguments.

=head2 name

Returns the value of the element C<<motif_name>>.

    # $motif is a Bio::Palantir::Parser::Motif
    my $name = $motif->name;

This method does not accept any arguments.

=head2 type

Returns the value of the element C<<motif_type>>.

    # $motif is a Bio::Palantir::Parser::Motif
    my $type = $motif->type;

This method does not accept any arguments.

=head2 sequence

Returns the value of the element C<<sequence>>.

    # $motif is a Bio::Palantir::Parser::Motif
    my $sequence = $motif->sequence;

This method does not accept any arguments.

=head2 detail

Returns the value of the element C<<detail>>.

    # $gene is a Bio::FastParsers::Biosynml::Gene
    my $detail = $gene->detail;

This method does not accept any arguments.

=head1 AUTHOR

Loic MEUNIER <lmeunier@uliege.be>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2019 by University of Liege / Unit of Eukaryotic Phylogenomics / Loic MEUNIER and Denis BAURAIN.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
