use v5.12;

# named colors from X11, HTML (SVG) standard and Pantone report

package Chart::Color::Constant;
our $VERSION = 'v2.403.2';
use Carp;
use Chart::Color::Value;

our %rgbhsl_from_name = (                                       # 2.6 MB
# http://en.wikipedia.org/wiki/Web_colors#X11_color_names
    'white'               => [ 255, 255, 255,   0,   0, 100 ],
    'black'               => [   0,   0,   0,   0,   0,   0 ],
    'red'                 => [ 255,   0,   0,   0, 100,  50 ],
    'green'               => [   0, 128,   0, 120, 100,  25 ],
    'blue'                => [   0,   0, 255, 240, 100,  50 ],
    'yellow'              => [ 255, 255,   0,  60, 100,  50 ],
    'purple'              => [ 128,   0, 128, 300, 100,  25 ],
    'pink'                => [ 255, 192, 203, 350, 100,  88 ],
    'peach'               => [ 250, 125, 125,   0,  93,  74 ],
    'plum'                => [ 221, 160, 221, 300,  47,  75 ],
    'mauve'               => [ 200, 125, 125,   0,  41,  64 ],
    'brown'               => [ 165,  42,  42,   0,  59,  41 ],
    'grey'                => [ 225, 225, 225,   0,   0,  88 ],
    'aliceblue'           => [ 240, 248, 255, 208, 100,  97 ],
    'antiquewhite'        => [ 250, 235, 215,  34,  78,  91 ],
    'antiquewhite1'       => [ 255, 239, 219,  33, 100,  93 ],
    'antiquewhite2'       => [ 238, 223, 204,  34,  50,  87 ],
    'antiquewhite3'       => [ 205, 192, 176,  33,  22,  75 ],
    'antiquewhite4'       => [ 139, 131, 120,  35,   8,  51 ],
    'aqua'                => [   0, 255, 255, 180, 100,  50 ],
    'aquamarine'          => [ 127, 255, 212, 160, 100,  75 ],
    'aquamarine1'         => [ 127, 255, 212, 160, 100,  75 ],
    'aquamarine2'         => [ 118, 238, 198, 160,  78,  70 ],
    'aquamarine3'         => [ 102, 205, 170, 160,  51,  60 ], # not in X11
    'aquamarine4'         => [  69, 139, 116, 160,  34,  41 ],
    'azure'               => [ 240, 255, 255, 180, 100,  97 ],
    'azure1'              => [ 240, 255, 255, 180, 100,  97 ],
    'azure2'              => [ 224, 238, 238, 180,  29,  91 ],
    'azure3'              => [ 193, 205, 205, 180,  11,  78 ],
    'azure4'              => [ 131, 139, 139, 180,   3,  53 ],
    'beige'               => [ 245, 245, 220,  60,  56,  91 ],
    'bisque'              => [ 255, 228, 196,  33, 100,  88 ],
    'bisque1'             => [ 255, 228, 196,  33, 100,  88 ],
    'bisque2'             => [ 238, 213, 183,  33,  62,  83 ],
    'bisque3'             => [ 205, 183, 158,  32,  32,  71 ],
    'bisque4'             => [ 139, 125, 107,  34,  13,  48 ],
    'blanchedalmond'      => [ 255, 235, 205,  36, 100,  90 ],
    'blue1'               => [   0,   0, 255, 240, 100,  50 ],
    'blue2'               => [   0,   0, 238, 240, 100,  47 ],
    'blue3'               => [   0,   0, 205, 240, 100,  40 ],
    'blue4'               => [   0,   0, 139, 240, 100,  27 ],
    'blueviolet'          => [ 138,  43, 226, 271,  76,  53 ],
    'brown1'              => [ 255,  64,  64,   0, 100,  63 ],
    'brown2'              => [ 238,  59,  59,   0,  84,  58 ],
    'brown3'              => [ 205,  51,  51,   0,  61,  50 ],
    'brown4'              => [ 139,  35,  35,   0,  60,  34 ],
    'burlywood'           => [ 222, 184, 135,  34,  57,  70 ],
    'burlywood1'          => [ 255, 211, 155,  34, 100,  80 ],
    'burlywood2'          => [ 238, 197, 145,  34,  73,  75 ],
    'burlywood3'          => [ 205, 170, 125,  34,  44,  65 ],
    'burlywood4'          => [ 139, 115,  85,  33,  24,  44 ],
    'cadetblue'           => [  95, 158, 160, 182,  25,  50 ],
    'cadetblue1'          => [ 152, 245, 255, 186, 100,  80 ],
    'cadetblue2'          => [ 142, 229, 238, 186,  74,  75 ],
    'cadetblue3'          => [ 122, 197, 205, 186,  45,  64 ],
    'cadetblue4'          => [  83, 134, 139, 185,  25,  44 ],
    'chartreuse'          => [ 127, 255,   0,  90, 100,  50 ],
    'chartreuse1'         => [ 127, 255,   0,  90, 100,  50 ],
    'chartreuse2'         => [ 118, 238,   0,  90, 100,  47 ],
    'chartreuse3'         => [ 102, 205,   0,  90, 100,  40 ],
    'chartreuse4'         => [  69, 139,   0,  90, 100,  27 ],
    'chocolate'           => [ 210, 105,  30,  25,  75,  47 ],
    'chocolate1'          => [ 255, 127,  36,  25, 100,  57 ],
    'chocolate2'          => [ 238, 118,  33,  25,  86,  53 ],
    'chocolate3'          => [ 205, 102,  29,  25,  75,  46 ],
    'chocolate4'          => [ 139,  69,  19,  25,  76,  31 ],
    'coral'               => [ 255, 127,  80,  16, 100,  66 ],
    'coral1'              => [ 255, 114,  86,  10, 100,  67 ],
    'coral2'              => [ 238, 106,  80,  10,  82,  62 ],
    'coral3'              => [ 205,  91,  69,  10,  58,  54 ],
    'coral4'              => [ 139,  62,  47,  10,  49,  36 ],
    'cornflowerblue'      => [ 100, 149, 237, 219,  79,  66 ],
    'cornsilk'            => [ 255, 248, 220,  48, 100,  93 ],
    'cornsilk1'           => [ 255, 248, 220,  48, 100,  93 ],
    'cornsilk2'           => [ 238, 232, 205,  49,  49,  87 ],
    'cornsilk3'           => [ 205, 200, 177,  49,  22,  75 ],
    'cornsilk4'           => [ 139, 136, 120,  51,   8,  51 ],
    'crimson'             => [ 220,  20,  60, 348,  83,  47 ],
    'cyan'                => [   0, 255, 255, 180, 100,  50 ],
    'cyan1'               => [   0, 255, 255, 180, 100,  50 ],
    'cyan2'               => [   0, 238, 238, 180, 100,  47 ],
    'cyan3'               => [   0, 205, 205, 180, 100,  40 ],
    'cyan4'               => [   0, 139, 139, 180, 100,  27 ],
    'darkblue'            => [   0,   0, 139, 240, 100,  27 ],
    'darkcyan'            => [   0, 139, 139, 180, 100,  27 ],
    'darkgoldenrod'       => [ 184, 134,  11,  43,  89,  38 ],
    'darkgoldenrod1'      => [ 255, 185,  15,  43, 100,  53 ],
    'darkgoldenrod2'      => [ 238, 173,  14,  43,  89,  49 ],
    'darkgoldenrod3'      => [ 205, 149,  12,  43,  89,  43 ],
    'darkgoldenrod4'      => [ 139, 101,   8,  43,  89,  29 ],
    'darkgray'            => [ 169, 169, 169,   0,   0,  66 ],
    'darkgreen'           => [   0, 100,   0, 120, 100,  20 ],
    'darkkhaki'           => [ 189, 183, 107,  56,  38,  58 ],
    'darkmagenta'         => [ 139,   0, 139, 300, 100,  27 ],
    'darkolivegreen'      => [  85, 107,  47,  82,  39,  30 ],
    'darkolivegreen1'     => [ 202, 255, 112,  82, 100,  72 ],
    'darkolivegreen2'     => [ 188, 238, 104,  82,  80,  67 ],
    'darkolivegreen3'     => [ 162, 205,  90,  82,  53,  58 ],
    'darkolivegreen4'     => [ 110, 139,  61,  82,  39,  39 ],
    'darkorange'          => [ 255, 140,   0,  33, 100,  50 ],
    'darkorange1'         => [ 255, 127,   0,  30, 100,  50 ],
    'darkorange2'         => [ 238, 118,   0,  30, 100,  47 ],
    'darkorange3'         => [ 205, 102,   0,  30, 100,  40 ],
    'darkorange4'         => [ 139,  69,   0,  30, 100,  27 ],
    'darkorchid'          => [ 153,  50, 204, 280,  61,  50 ],
    'darkorchid1'         => [ 191,  62, 255, 280, 100,  62 ],
    'darkorchid2'         => [ 178,  58, 238, 280,  84,  58 ],
    'darkorchid3'         => [ 154,  50, 205, 280,  61,  50 ],
    'darkorchid4'         => [ 104,  34, 139, 280,  61,  34 ],
    'darkred'             => [ 139,   0,   0,   0, 100,  27 ],
    'darksalmon'          => [ 233, 150, 122,  15,  72,  70 ],
    'darkseagreen'        => [ 143, 188, 143, 120,  25,  65 ],
    'darkseagreen1'       => [ 193, 255, 193, 120, 100,  88 ],
    'darkseagreen2'       => [ 180, 238, 180, 120,  63,  82 ],
    'darkseagreen3'       => [ 155, 205, 155, 120,  33,  71 ],
    'darkseagreen4'       => [ 105, 139, 105, 120,  14,  48 ],
    'darkslateblue'       => [  72,  61, 139, 248,  39,  39 ],
    'darkslategray'       => [  47,  79,  79, 180,  25,  25 ],
    'darkslategray1'      => [ 151, 255, 255, 180, 100,  80 ],
    'darkslategray2'      => [ 141, 238, 238, 180,  74,  74 ],
    'darkslategray3'      => [ 121, 205, 205, 180,  46,  64 ],
    'darkslategray4'      => [  82, 139, 139, 180,  26,  43 ],
    'darkturquoise'       => [   0, 206, 209, 181, 100,  41 ],
    'darkviolet'          => [ 148,   0, 211, 282, 100,  41 ],
    'deeppink'            => [ 255,  20, 147, 328, 100,  54 ],
    'deeppink1'           => [ 255,  20, 147, 328, 100,  54 ],
    'deeppink2'           => [ 238,  18, 137, 328,  87,  50 ],
    'deeppink3'           => [ 205,  16, 118, 328,  86,  43 ],
    'deeppink4'           => [ 139,  10,  80, 327,  87,  29 ],
    'deepskyblue'         => [   0, 191, 255, 195, 100,  50 ],
    'deepskyblue1'        => [   0, 191, 255, 195, 100,  50 ],
    'deepskyblue2'        => [   0, 178, 238, 195, 100,  47 ],
    'deepskyblue3'        => [   0, 154, 205, 195, 100,  40 ],
    'deepskyblue4'        => [   0, 104, 139, 195, 100,  27 ],
    'dimgray'             => [ 105, 105, 105,   0,   0,  41 ],
    'dodgerblue'          => [  30, 144, 255, 210, 100,  56 ],
    'dodgerblue1'         => [  30, 144, 255, 210, 100,  56 ],
    'dodgerblue2'         => [  28, 134, 238, 210,  86,  52 ],
    'dodgerblue3'         => [  24, 116, 205, 210,  79,  45 ],
    'dodgerblue4'         => [  16,  78, 139, 210,  79,  30 ],
    'firebrick'           => [ 178,  34,  34,   0,  68,  42 ],
    'firebrick1'          => [ 255,  48,  48,   0, 100,  59 ],
    'firebrick2'          => [ 238,  44,  44,   0,  85,  55 ],
    'firebrick3'          => [ 205,  38,  38,   0,  69,  48 ],
    'firebrick4'          => [ 139,  26,  26,   0,  68,  32 ],
    'floralwhite'         => [ 255, 250, 240,  40, 100,  97 ],
    'forestgreen'         => [  34, 139,  34, 120,  61,  34 ],
    'fuchsia'             => [ 255,   0, 255, 300, 100,  50 ],
    'gainsboro'           => [ 220, 220, 220,   0,   0,  86 ],
    'ghostwhite'          => [ 248, 248, 255, 240, 100,  99 ],
    'gold'                => [ 255, 215,   0,  51, 100,  50 ],
    'gold1'               => [ 255, 215,   0,  51, 100,  50 ],
    'gold2'               => [ 238, 201,   0,  51, 100,  47 ],
    'gold3'               => [ 205, 173,   0,  51, 100,  40 ],
    'gold4'               => [ 139, 117,   0,  51, 100,  27 ],
    'goldenrod'           => [ 218, 165,  32,  43,  74,  49 ],
    'goldenrod1'          => [ 255, 193,  37,  43, 100,  57 ],
    'goldenrod2'          => [ 238, 180,  34,  43,  86,  53 ],
    'goldenrod3'          => [ 205, 155,  29,  43,  75,  46 ],
    'goldenrod4'          => [ 139, 105,  20,  43,  75,  31 ],
    'gray'                => [ 128, 128, 128,   0,   0,  50 ],
    'gray1'               => [   3,   3,   3,   0,   0,   1 ],
    'gray2'               => [   5,   5,   5,   0,   0,   2 ],
    'gray3'               => [   8,   8,   8,   0,   0,   3 ],
    'gray4'               => [  10,  10,  10,   0,   0,   4 ],
    'gray5'               => [  13,  13,  13,   0,   0,   5 ],
    'gray6'               => [  15,  15,  15,   0,   0,   6 ],
    'gray7'               => [  18,  18,  18,   0,   0,   7 ],
    'gray8'               => [  20,  20,  20,   0,   0,   8 ],
    'gray9'               => [  23,  23,  23,   0,   0,   9 ],
    'gray10'              => [  26,  26,  26,   0,   0,  10 ],
    'gray11'              => [  28,  28,  28,   0,   0,  11 ],
    'gray12'              => [  31,  31,  31,   0,   0,  12 ],
    'gray13'              => [  33,  33,  33,   0,   0,  13 ],
    'gray14'              => [  36,  36,  36,   0,   0,  14 ],
    'gray15'              => [  38,  38,  38,   0,   0,  15 ],
    'gray16'              => [  41,  41,  41,   0,   0,  16 ],
    'gray17'              => [  43,  43,  43,   0,   0,  17 ],
    'gray18'              => [  46,  46,  46,   0,   0,  18 ],
    'gray19'              => [  48,  48,  48,   0,   0,  19 ],
    'gray20'              => [  51,  51,  51,   0,   0,  20 ],
    'gray21'              => [  54,  54,  54,   0,   0,  21 ],
    'gray22'              => [  56,  56,  56,   0,   0,  22 ],
    'gray23'              => [  59,  59,  59,   0,   0,  23 ],
    'gray24'              => [  61,  61,  61,   0,   0,  24 ],
    'gray25'              => [  64,  64,  64,   0,   0,  25 ],
    'gray26'              => [  66,  66,  66,   0,   0,  26 ],
    'gray27'              => [  69,  69,  69,   0,   0,  27 ],
    'gray28'              => [  71,  71,  71,   0,   0,  28 ],
    'gray29'              => [  74,  74,  74,   0,   0,  29 ],
    'gray30'              => [  77,  77,  77,   0,   0,  30 ],
    'gray31'              => [  79,  79,  79,   0,   0,  31 ],
    'gray32'              => [  82,  82,  82,   0,   0,  32 ],
    'gray33'              => [  84,  84,  84,   0,   0,  33 ],
    'gray34'              => [  87,  87,  87,   0,   0,  34 ],
    'gray35'              => [  89,  89,  89,   0,   0,  35 ],
    'gray36'              => [  92,  92,  92,   0,   0,  36 ],
    'gray37'              => [  94,  94,  94,   0,   0,  37 ],
    'gray38'              => [  97,  97,  97,   0,   0,  38 ],
    'gray39'              => [  99,  99,  99,   0,   0,  39 ],
    'gray40'              => [ 102, 102, 102,   0,   0,  40 ],
    'gray41'              => [ 105, 105, 105,   0,   0,  41 ],
    'gray42'              => [ 107, 107, 107,   0,   0,  42 ],
    'gray43'              => [ 110, 110, 110,   0,   0,  43 ],
    'gray44'              => [ 112, 112, 112,   0,   0,  44 ],
    'gray45'              => [ 115, 115, 115,   0,   0,  45 ],
    'gray46'              => [ 117, 117, 117,   0,   0,  46 ],
    'gray47'              => [ 120, 120, 120,   0,   0,  47 ],
    'gray48'              => [ 122, 122, 122,   0,   0,  48 ],
    'gray49'              => [ 125, 125, 125,   0,   0,  49 ],
    'gray50'              => [ 127, 127, 127,   0,   0,  50 ],
    'gray51'              => [ 130, 130, 130,   0,   0,  51 ],
    'gray52'              => [ 133, 133, 133,   0,   0,  52 ],
    'gray53'              => [ 135, 135, 135,   0,   0,  53 ],
    'gray54'              => [ 138, 138, 138,   0,   0,  54 ],
    'gray55'              => [ 140, 140, 140,   0,   0,  55 ],
    'gray56'              => [ 143, 143, 143,   0,   0,  56 ],
    'gray57'              => [ 145, 145, 145,   0,   0,  57 ],
    'gray58'              => [ 148, 148, 148,   0,   0,  58 ],
    'gray59'              => [ 150, 150, 150,   0,   0,  59 ],
    'gray60'              => [ 153, 153, 153,   0,   0,  60 ],
    'gray61'              => [ 156, 156, 156,   0,   0,  61 ],
    'gray62'              => [ 158, 158, 158,   0,   0,  62 ],
    'gray63'              => [ 161, 161, 161,   0,   0,  63 ],
    'gray64'              => [ 163, 163, 163,   0,   0,  64 ],
    'gray65'              => [ 166, 166, 166,   0,   0,  65 ],
    'gray66'              => [ 168, 168, 168,   0,   0,  66 ],
    'gray67'              => [ 171, 171, 171,   0,   0,  67 ],
    'gray68'              => [ 173, 173, 173,   0,   0,  68 ],
    'gray69'              => [ 176, 176, 176,   0,   0,  69 ],
    'gray70'              => [ 179, 179, 179,   0,   0,  70 ],
    'gray71'              => [ 181, 181, 181,   0,   0,  71 ],
    'gray72'              => [ 184, 184, 184,   0,   0,  72 ],
    'gray73'              => [ 186, 186, 186,   0,   0,  73 ],
    'gray74'              => [ 189, 189, 189,   0,   0,  74 ],
    'gray75'              => [ 191, 191, 191,   0,   0,  75 ],
    'gray76'              => [ 194, 194, 194,   0,   0,  76 ],
    'gray77'              => [ 196, 196, 196,   0,   0,  77 ],
    'gray78'              => [ 199, 199, 199,   0,   0,  78 ],
    'gray79'              => [ 201, 201, 201,   0,   0,  79 ],
    'gray80'              => [ 204, 204, 204,   0,   0,  80 ],
    'gray81'              => [ 207, 207, 207,   0,   0,  81 ],
    'gray82'              => [ 209, 209, 209,   0,   0,  82 ],
    'gray83'              => [ 212, 212, 212,   0,   0,  83 ],
    'gray84'              => [ 214, 214, 214,   0,   0,  84 ],
    'gray85'              => [ 217, 217, 217,   0,   0,  85 ],
    'gray86'              => [ 219, 219, 219,   0,   0,  86 ],
    'gray87'              => [ 222, 222, 222,   0,   0,  87 ],
    'gray88'              => [ 224, 224, 224,   0,   0,  88 ],
    'gray89'              => [ 227, 227, 227,   0,   0,  89 ],
    'gray90'              => [ 229, 229, 229,   0,   0,  90 ],
    'gray91'              => [ 232, 232, 232,   0,   0,  91 ],
    'gray92'              => [ 235, 235, 235,   0,   0,  92 ],
    'gray93'              => [ 237, 237, 237,   0,   0,  93 ],
    'gray94'              => [ 240, 240, 240,   0,   0,  94 ],
    'gray95'              => [ 242, 242, 242,   0,   0,  95 ],
    'gray97'              => [ 247, 247, 247,   0,   0,  97 ],
    'gray98'              => [ 250, 250, 250,   0,   0,  98 ],
    'gray99'              => [ 252, 252, 252,   0,   0,  99 ],
    'green1'              => [   0, 255,   0, 120, 100,  50 ],
    'green2'              => [   0, 238,   0, 120, 100,  47 ],
    'green3'              => [   0, 205,   0, 120, 100,  40 ],
    'green4'              => [   0, 139,   0, 120, 100,  27 ],
    'greenyellow'         => [ 173, 255,  47,  84, 100,  59 ],
    'grey1'               => [   3,   3,   3,   0,   0,   1 ],
    'grey2'               => [   5,   5,   5,   0,   0,   2 ],
    'grey3'               => [   8,   8,   8,   0,   0,   3 ],
    'grey4'               => [  10,  10,  10,   0,   0,   4 ],
    'honeydew'            => [ 240, 255, 240, 120, 100,  97 ],
    'honeydew1'           => [ 240, 255, 240, 120, 100,  97 ],
    'honeydew2'           => [ 224, 238, 224, 120,  29,  91 ],
    'honeydew3'           => [ 193, 205, 193, 120,  11,  78 ],
    'honeydew4'           => [ 131, 139, 131, 120,   3,  53 ],
    'hotpink'             => [ 255, 105, 180, 330, 100,  71 ],
    'hotpink1'            => [ 255, 110, 180, 331, 100,  72 ],
    'hotpink2'            => [ 238, 106, 167, 332,  80,  67 ],
    'hotpink3'            => [ 205,  96, 144, 334,  52,  59 ],
    'hotpink4'            => [ 139,  58,  98, 330,  41,  39 ],
    'indianred'           => [ 205,  92,  92,   0,  53,  58 ],
    'indianred1'          => [ 255, 106, 106,   0, 100,  71 ],
    'indianred2'          => [ 238,  99,  99,   0,  80,  66 ],
    'indianred3'          => [ 205,  85,  85,   0,  55,  57 ],
    'indianred4'          => [ 139,  58,  58,   0,  41,  39 ],
    'indigo'              => [  75,   0, 130, 275, 100,  25 ],
    'ivory'               => [ 255, 255, 240,  60, 100,  97 ],
    'ivory1'              => [ 255, 255, 240,  60, 100,  97 ],
    'ivory2'              => [ 238, 238, 224,  60,  29,  91 ],
    'ivory3'              => [ 205, 205, 193,  60,  11,  78 ],
    'ivory4'              => [ 139, 139, 131,  60,   3,  53 ],
    'khaki'               => [ 240, 230, 140,  54,  77,  75 ],
    'khaki1'              => [ 255, 246, 143,  55, 100,  78 ],
    'khaki2'              => [ 238, 230, 133,  55,  76,  73 ],
    'khaki3'              => [ 205, 198, 115,  55,  47,  63 ],
    'khaki4'              => [ 139, 134,  78,  55,  28,  43 ],
    'lavender'            => [ 230, 230, 250, 240,  67,  94 ],
    'lavenderblush'       => [ 255, 240, 245, 340, 100,  97 ],
    'lavenderblush1'      => [ 255, 240, 245, 340, 100,  97 ],
    'lavenderblush2'      => [ 238, 224, 229, 339,  29,  91 ],
    'lavenderblush3'      => [ 205, 193, 197, 340,  11,  78 ],
    'lavenderblush4'      => [ 139, 131, 134, 338,   3,  53 ],
    'lawngreen'           => [ 124, 252,   0,  90, 100,  49 ],
    'lemonchiffon'        => [ 255, 250, 205,  54, 100,  90 ],
    'lemonchiffon1'       => [ 255, 250, 205,  54, 100,  90 ],
    'lemonchiffon2'       => [ 238, 233, 191,  54,  58,  84 ],
    'lemonchiffon3'       => [ 205, 201, 165,  54,  29,  73 ],
    'lemonchiffon4'       => [ 139, 137, 112,  56,  11,  49 ],
    'light'               => [ 238, 221, 130,  51,  76,  72 ],
    'lightblue'           => [ 173, 216, 230, 195,  53,  79 ],
    'lightblue1'          => [ 191, 239, 255, 195, 100,  87 ],
    'lightblue2'          => [ 178, 223, 238, 195,  64,  82 ],
    'lightblue3'          => [ 154, 192, 205, 195,  34,  70 ],
    'lightblue4'          => [ 104, 131, 139, 194,  14,  48 ],
    'lightcoral'          => [ 240, 128, 128,   0,  79,  72 ],
    'lightcyan'           => [ 224, 255, 255, 180, 100,  94 ],
    'lightcyan1'          => [ 224, 255, 255, 180, 100,  94 ],
    'lightcyan2'          => [ 209, 238, 238, 180,  46,  88 ],
    'lightcyan3'          => [ 180, 205, 205, 180,  20,  75 ],
    'lightcyan4'          => [ 122, 139, 139, 180,   7,  51 ],
    'lightgoldenrod'      => [ 238, 221, 130,  51,  76,  72 ],
    'lightgoldenrod1'     => [ 255, 236, 139,  50, 100,  77 ],
    'lightgoldenrod2'     => [ 238, 220, 130,  50,  76,  72 ],
    'lightgoldenrod3'     => [ 205, 190, 112,  50,  48,  62 ],
    'lightgoldenrod4'     => [ 139, 129,  76,  50,  29,  42 ],
    'lightgray'           => [ 211, 211, 211,   0,   0,  83 ],
    'lightgreen'          => [ 144, 238, 144, 120,  73,  75 ],
    'lightpink'           => [ 255, 182, 193, 351, 100,  86 ],
    'lightpink1'          => [ 255, 174, 185, 352, 100,  84 ],
    'lightpink2'          => [ 238, 162, 173, 351,  69,  78 ],
    'lightpink3'          => [ 205, 140, 149, 352,  39,  68 ],
    'lightpink4'          => [ 139,  95, 101, 352,  19,  46 ],
    'lightpurple'         => [ 145,   0, 250, 275, 100,  49 ], # not in X11
    'lightsalmon'         => [ 255, 160, 122,  17, 100,  74 ],
    'lightsalmon1'        => [ 255, 160, 122,  17, 100,  74 ],
    'lightsalmon2'        => [ 238, 149, 114,  17,  78,  69 ],
    'lightsalmon3'        => [ 205, 129,  98,  17,  52,  59 ],
    'lightsalmon4'        => [ 139,  87,  66,  17,  36,  40 ],
    'lightseagreen'       => [  32, 178, 170, 177,  70,  41 ],
    'lightskyblue'        => [ 135, 206, 250, 203,  92,  75 ],
    'lightskyblue1'       => [ 176, 226, 255, 202, 100,  85 ],
    'lightskyblue2'       => [ 164, 211, 238, 202,  69,  79 ],
    'lightskyblue3'       => [ 141, 182, 205, 202,  39,  68 ],
    'lightskyblue4'       => [  96, 123, 139, 202,  18,  46 ],
    'lightslateblue'      => [ 132, 112, 255, 248, 100,  72 ],
    'lightslategray'      => [ 119, 136, 153, 210,  14,  53 ],
    'lightsteelblue'      => [ 176, 196, 222, 214,  41,  78 ],
    'lightsteelblue1'     => [ 202, 225, 255, 214, 100,  90 ],
    'lightsteelblue2'     => [ 188, 210, 238, 214,  60,  84 ],
    'lightsteelblue3'     => [ 162, 181, 205, 213,  30,  72 ],
    'lightsteelblue4'     => [ 110, 123, 139, 213,  12,  49 ],
    'lightyellow'         => [ 255, 255, 224,  60, 100,  94 ],
    'lightyellow1'        => [ 255, 255, 224,  60, 100,  94 ],
    'lightyellow2'        => [ 238, 238, 209,  60,  46,  88 ],
    'lightyellow3'        => [ 205, 205, 180,  60,  20,  75 ],
    'lightyellow4'        => [ 139, 139, 122,  60,   7,  51 ],
    'lime'                => [   0, 255,   0, 120, 100,  50 ],
    'limegreen'           => [  50, 205,  50, 120,  61,  50 ],
    'linen'               => [ 250, 240, 230,  30,  67,  94 ],
    'magenta'             => [ 255,   0, 255, 300, 100,  50 ],
    'magenta1'            => [ 255,   0, 255, 300, 100,  50 ],
    'magenta2'            => [ 238,   0, 238, 300, 100,  47 ],
    'magenta3'            => [ 205,   0, 205, 300, 100,  40 ],
    'magenta4'            => [ 139,   0, 139, 300, 100,  27 ],
    'maroon'              => [ 128,   0,   0,   0, 100,  25 ],
    'maroon1'             => [ 255,  52, 179, 322, 100,  60 ],
    'maroon2'             => [ 238,  48, 167, 322,  85,  56 ],
    'maroon3'             => [ 205,  41, 144, 322,  67,  48 ],
    'maroon4'             => [ 139,  28,  98, 322,  66,  33 ],
    'medium'              => [ 102, 205, 170, 160,  51,  60 ],
    'mediumaquamarine'    => [ 102, 205, 170, 160,  51,  60 ],
    'mediumblue'          => [   0,   0, 205, 240, 100,  40 ],
    'mediumorchid'        => [ 186,  85, 211, 288,  59,  58 ],
    'mediumorchid1'       => [ 224, 102, 255, 288, 100,  70 ],
    'mediumorchid2'       => [ 209,  95, 238, 288,  81,  65 ],
    'mediumorchid3'       => [ 180,  82, 205, 288,  55,  56 ],
    'mediumorchid4'       => [ 122,  55, 139, 288,  43,  38 ],
    'mediumpurple'        => [ 147, 112, 219, 260,  60,  65 ],
    'mediumpurple1'       => [ 171, 130, 255, 260, 100,  75 ],
    'mediumpurple2'       => [ 159, 121, 238, 259,  77,  70 ],
    'mediumpurple3'       => [ 137, 104, 205, 260,  50,  61 ],
    'mediumpurple4'       => [  93,  71, 139, 259,  32,  41 ],
    'mediumseagreen'      => [  60, 179, 113, 147,  50,  47 ],
    'mediumslateblue'     => [ 123, 104, 238, 249,  80,  67 ],
    'mediumspringgreen'   => [   0, 250, 154, 157, 100,  49 ],
    'mediumturquoise'     => [  72, 209, 204, 178,  60,  55 ],
    'mediumvioletred'     => [ 199,  21, 133, 322,  81,  43 ],
    'midnightblue'        => [  25,  25, 112, 240,  64,  27 ],
    'mintcream'           => [ 245, 255, 250, 150, 100,  98 ],
    'mistyrose'           => [ 255, 228, 225,   6, 100,  94 ],
    'mistyrose1'          => [ 255, 228, 225,   6, 100,  94 ],
    'mistyrose2'          => [ 238, 213, 210,   6,  45,  88 ],
    'mistyrose3'          => [ 205, 183, 181,   5,  19,  76 ],
    'mistyrose4'          => [ 139, 125, 123,   8,   6,  51 ],
    'moccasin'            => [ 255, 228, 181,  38, 100,  85 ],
    'navajowhite'         => [ 255, 222, 173,  36, 100,  84 ],
    'navajowhite1'        => [ 255, 222, 173,  36, 100,  84 ],
    'navajowhite2'        => [ 238, 207, 161,  36,  69,  78 ],
    'navajowhite3'        => [ 205, 179, 139,  36,  40,  67 ],
    'navajowhite4'        => [ 139, 121,  94,  36,  19,  46 ],
    'navy'                => [   0,   0, 128, 240, 100,  25 ],
    'navyblue'            => [   0,   0, 128, 240, 100,  25 ],
    'oldlace'             => [ 253, 245, 230,  39,  85,  95 ],
    'olive'               => [ 128, 128,   0,  60, 100,  25 ],
    'olivedrab'           => [ 107, 142,  35,  80,  60,  35 ],
    'olivedrab1'          => [ 192, 255,  62,  80, 100,  62 ],
    'olivedrab2'          => [ 179, 238,  58,  80,  84,  58 ],
    'olivedrab3'          => [ 154, 205,  50,  80,  61,  50 ],
    'olivedrab4'          => [ 105, 139,  34,  79,  61,  34 ],
    'orange'              => [ 255, 165,   0,  39, 100,  50 ],
    'orange1'             => [ 255, 165,   0,  39, 100,  50 ],
    'orange2'             => [ 238, 154,   0,  39, 100,  47 ],
    'orange3'             => [ 205, 133,   0,  39, 100,  40 ],
    'orange4'             => [ 139,  90,   0,  39, 100,  27 ],
    'orangered'           => [ 255,  69,   0,  16, 100,  50 ],
    'orangered1'          => [ 255,  69,   0,  16, 100,  50 ],
    'orangered2'          => [ 238,  64,   0,  16, 100,  47 ],
    'orangered3'          => [ 205,  55,   0,  16, 100,  40 ],
    'orangered4'          => [ 139,  37,   0,  16, 100,  27 ],
    'orchid'              => [ 218, 112, 214, 302,  59,  65 ],
    'orchid1'             => [ 255, 131, 250, 302, 100,  76 ],
    'orchid2'             => [ 238, 122, 233, 303,  77,  71 ],
    'orchid3'             => [ 205, 105, 201, 302,  50,  61 ],
    'orchid4'             => [ 139,  71, 137, 302,  32,  41 ],
    'pale'                => [ 219, 112, 147, 340,  60,  65 ],
    'palegoldenrod'       => [ 238, 232, 170,  55,  67,  80 ],
    'palegreen'           => [ 152, 251, 152, 120,  93,  79 ],
    'palegreen1'          => [ 154, 255, 154, 120, 100,  80 ],
    'palegreen2'          => [ 144, 238, 144, 120,  73,  75 ],
    'palegreen3'          => [ 124, 205, 124, 120,  45,  65 ],
    'palegreen4'          => [  84, 139,  84, 120,  25,  44 ],
    'paleturquoise'       => [ 175, 238, 238, 180,  65,  81 ],
    'paleturquoise1'      => [ 187, 255, 255, 180, 100,  87 ],
    'paleturquoise2'      => [ 174, 238, 238, 180,  65,  81 ],
    'paleturquoise3'      => [ 150, 205, 205, 180,  35,  70 ],
    'paleturquoise4'      => [ 102, 139, 139, 180,  15,  47 ],
    'palevioletred'       => [ 219, 112, 147, 340,  60,  65 ],
    'palevioletred1'      => [ 255, 130, 171, 340, 100,  75 ],
    'palevioletred2'      => [ 238, 121, 159, 341,  77,  70 ],
    'palevioletred3'      => [ 205, 104, 137, 340,  50,  61 ],
    'palevioletred4'      => [ 139,  71,  93, 341,  32,  41 ],
    'papayawhip'          => [ 255, 239, 213,  37, 100,  92 ],
    'peachpuff'           => [ 255, 218, 185,  28, 100,  86 ],
    'peachpuff1'          => [ 255, 218, 185,  28, 100,  86 ],
    'peachpuff2'          => [ 238, 203, 173,  28,  66,  81 ],
    'peachpuff3'          => [ 205, 175, 149,  28,  36,  69 ],
    'peachpuff4'          => [ 139, 119, 101,  28,  16,  47 ],
    'peru'                => [ 205, 133,  63,  30,  59,  53 ],
    'pink1'               => [ 255, 181, 197, 347, 100,  85 ],
    'pink2'               => [ 238, 169, 184, 347,  67,  80 ],
    'pink3'               => [ 205, 145, 158, 347,  38,  69 ],
    'pink4'               => [ 139,  99, 108, 347,  17,  47 ],
    'plum1'               => [ 255, 187, 255, 300, 100,  87 ],
    'plum2'               => [ 238, 174, 238, 300,  65,  81 ],
    'plum3'               => [ 205, 150, 205, 300,  35,  70 ],
    'plum4'               => [ 139, 102, 139, 300,  15,  47 ],
    'powderblue'          => [ 176, 224, 230, 187,  52,  80 ],
    'purple1'             => [ 155,  48, 255, 271, 100,  59 ],
    'purple2'             => [ 145,  44, 238, 271,  85,  55 ],
    'purple3'             => [ 125,  38, 205, 271,  69,  48 ],
    'purple4'             => [  85,  26, 139, 271,  68,  32 ],
    'rebeccapurple'       => [ 102,  51, 153, 270,  50,  40 ],
    'red1'                => [ 255,   0,   0,   0, 100,  50 ],
    'red2'                => [ 238,   0,   0,   0, 100,  47 ],
    'red3'                => [ 205,   0,   0,   0, 100,  40 ],
    'red4'                => [ 139,   0,   0,   0, 100,  27 ],
    'rosybrown'           => [ 188, 143, 143,   0,  25,  65 ],
    'rosybrown1'          => [ 255, 193, 193,   0, 100,  88 ],
    'rosybrown2'          => [ 238, 180, 180,   0,  63,  82 ],
    'rosybrown3'          => [ 205, 155, 155,   0,  33,  71 ],
    'rosybrown4'          => [ 139, 105, 105,   0,  14,  48 ],
    'royalblue'           => [  65, 105, 225, 225,  73,  57 ],
    'royalblue1'          => [  72, 118, 255, 225, 100,  64 ],
    'royalblue2'          => [  67, 110, 238, 225,  83,  60 ],
    'royalblue3'          => [  58,  95, 205, 225,  60,  52 ],
    'royalblue4'          => [  39,  64, 139, 225,  56,  35 ],
    'saddlebrown'         => [ 139,  69,  19,  25,  76,  31 ],
    'salmon'              => [ 250, 128, 114,   6,  93,  71 ],
    'salmon1'             => [ 255, 140, 105,  14, 100,  71 ],
    'salmon2'             => [ 238, 130,  98,  14,  80,  66 ],
    'salmon3'             => [ 205, 112,  84,  14,  55,  57 ],
    'salmon4'             => [ 139,  76,  57,  14,  42,  38 ],
    'sandybrown'          => [ 244, 164,  96,  28,  87,  67 ],
    'seagreen'            => [  46, 139,  87, 146,  50,  36 ],
    'seagreen1'           => [  84, 255, 159, 146, 100,  66 ],
    'seagreen2'           => [  78, 238, 148, 146,  82,  62 ],
    'seagreen3'           => [  67, 205, 128, 147,  58,  53 ],
    'seagreen4'           => [  46, 139,  87, 146,  50,  36 ],
    'seashell'            => [ 255, 245, 238,  25, 100,  97 ],
    'seashell1'           => [ 255, 245, 238,  25, 100,  97 ],
    'seashell2'           => [ 238, 229, 222,  26,  32,  90 ],
    'seashell3'           => [ 205, 197, 191,  26,  12,  78 ],
    'seashell4'           => [ 139, 134, 130,  27,   4,  53 ],
    'sienna'              => [ 160,  82,  45,  19,  56,  40 ],
    'sienna1'             => [ 255, 130,  71,  19, 100,  64 ],
    'sienna2'             => [ 238, 121,  66,  19,  83,  60 ],
    'sienna3'             => [ 205, 104,  57,  19,  60,  51 ],
    'sienna4'             => [ 139,  71,  38,  20,  57,  35 ],
    'silver'              => [ 192, 192, 192,   0,   0,  75 ],
    'skyblue'             => [ 135, 206, 235, 197,  71,  73 ],
    'skyblue1'            => [ 135, 206, 255, 205, 100,  76 ],
    'skyblue2'            => [ 126, 192, 238, 205,  77,  71 ],
    'skyblue3'            => [ 108, 166, 205, 204,  49,  61 ],
    'skyblue4'            => [  74, 112, 139, 205,  31,  42 ],
    'slateblue'           => [ 106,  90, 205, 248,  53,  58 ],
    'slateblue1'          => [ 131, 111, 255, 248, 100,  72 ],
    'slateblue2'          => [ 122, 103, 238, 248,  80,  67 ],
    'slateblue3'          => [ 105,  89, 205, 248,  54,  58 ],
    'slateblue4'          => [  71,  60, 139, 248,  40,  39 ],
    'slategray'           => [ 112, 128, 144, 210,  13,  50 ],
    'slategray1'          => [ 198, 226, 255, 211, 100,  89 ],
    'slategray2'          => [ 185, 211, 238, 211,  61,  83 ],
    'slategray3'          => [ 159, 182, 205, 210,  32,  71 ],
    'slategray4'          => [ 108, 123, 139, 211,  13,  48 ],
    'snow'                => [ 255, 250, 250,   0, 100,  99 ],
    'snow1'               => [ 255, 250, 250,   0, 100,  99 ],
    'snow2'               => [ 238, 233, 233,   0,  13,  92 ],
    'snow3'               => [ 205, 201, 201,   0,   4,  80 ],
    'snow4'               => [ 139, 137, 137,   0,   1,  54 ],
    'springgreen'         => [   0, 255, 127, 150, 100,  50 ],
    'springgreen1'        => [   0, 255, 127, 150, 100,  50 ],
    'springgreen2'        => [   0, 238, 118, 150, 100,  47 ],
    'springgreen3'        => [   0, 205, 102, 150, 100,  40 ],
    'springgreen4'        => [   0, 139,  69, 150, 100,  27 ],
    'steelblue'           => [  70, 130, 180, 207,  44,  49 ],
    'steelblue1'          => [  99, 184, 255, 207, 100,  69 ],
    'steelblue2'          => [  92, 172, 238, 207,  81,  65 ],
    'steelblue3'          => [  79, 148, 205, 207,  56,  56 ],
    'steelblue4'          => [  54, 100, 139, 208,  44,  38 ],
    'tan'                 => [ 210, 180, 140,  34,  44,  69 ],
    'tan1'                => [ 255, 165,  79,  29, 100,  65 ],
    'tan2'                => [ 238, 154,  73,  29,  83,  61 ],
    'tan3'                => [ 205, 133,  63,  30,  59,  53 ],
    'tan4'                => [ 139,  90,  43,  29,  53,  36 ],
    'teal'                => [   0, 128, 128, 180, 100,  25 ],
    'thistle'             => [ 216, 191, 216, 300,  24,  80 ],
    'thistle1'            => [ 255, 225, 255, 300, 100,  94 ],
    'thistle2'            => [ 238, 210, 238, 300,  45,  88 ],
    'thistle3'            => [ 205, 181, 205, 300,  19,  76 ],
    'thistle4'            => [ 139, 123, 139, 300,   6,  51 ],
    'tomato'              => [ 255,  99,  71,   9, 100,  64 ],
    'tomato1'             => [ 255,  99,  71,   9, 100,  64 ],
    'tomato2'             => [ 238,  92,  66,   9,  83,  60 ],
    'tomato3'             => [ 205,  79,  57,   9,  60,  51 ],
    'tomato4'             => [ 139,  54,  38,  10,  57,  35 ],
    'turquoise'           => [  69, 184, 172, 174,  45,  50 ],
    'turquoise1'          => [   0, 245, 255, 182, 100,  50 ],
    'turquoise2'          => [   0, 229, 238, 182, 100,  47 ],
    'turquoise3'          => [   0, 197, 205, 182, 100,  40 ],
    'turquoise4'          => [   0, 134, 139, 182, 100,  27 ],
    'violet'              => [ 238, 130, 238, 300,  76,  72 ],
    'violetred'           => [ 208,  32, 144, 322,  73,  47 ],
    'violetred1'          => [ 255,  62, 150, 333, 100,  62 ],
    'violetred2'          => [ 238,  58, 140, 333,  84,  58 ],
    'violetred3'          => [ 205,  50, 120, 333,  61,  50 ],
    'violetred4'          => [ 139,  34,  82, 333,  61,  34 ],
    'wheat'               => [ 245, 222, 179,  39,  77,  83 ],
    'wheat1'              => [ 255, 231, 186,  39, 100,  86 ],
    'wheat2'              => [ 238, 216, 174,  39,  65,  81 ],
    'wheat3'              => [ 205, 186, 150,  39,  35,  70 ],
    'wheat4'              => [ 139, 126, 102,  39,  15,  47 ],
    'whitesmoke'          => [ 245, 245, 245,   0,   0,  96 ],
    'yellow1'             => [ 255, 255,   0,  60, 100,  50 ],
    'yellow2'             => [ 238, 238,   0,  60, 100,  47 ],
    'yellow3'             => [ 205, 205,   0,  60, 100,  40 ],
    'yellow4'             => [ 139, 139,   0,  60, 100,  27 ],
    'yellowgreen'         => [ 154, 205,  50,  80,  61,  50 ],
# https://www.w3schools.com/colors/colors_trends.asp
    'marsala'             => [ 149,  82,  81,   1,  30,  45 ], # best 2015-2000
    'radiandorchid'       => [ 181, 101, 167, 311,  35,  55 ],
    'emerald'             => [   0, 155, 119, 166, 100,  30 ],
    'tangerinetango'      => [ 221,  65,  36,   9,  73,  50 ],
    'honeysucle'          => [ 214,  80, 118, 343,  62,  58 ],
    'turquoise'           => [  69, 184, 172, 174,  45,  50 ],
    'mimosa'              => [ 239, 192,  80,  42,  83,  63 ],
    'blueizis'            => [  91,  94, 166, 238,  30,  50 ],
    'chilipepper'         => [ 155,  27,  48, 350,  70,  36 ],
    'sanddollar'          => [ 223, 207, 190,  31,  34,  81 ],
    'blueturquoise'       => [  85, 180, 176, 177,  39,  52 ],
    'tigerlily'           => [ 225,  93,  68,  10,  72,  57 ],
    'aquasky'             => [ 127, 205, 205, 180,  44,  65 ],
    'truered'             => [ 188,  36,  60, 351,  68,  44 ],
    'fuchsiarose'         => [ 195,  68, 122, 334,  51,  52 ],
    'ceruleanblue'        => [ 152, 180, 212, 212,  41,  71 ],
    'rosequartz'          => [ 247, 202, 201,   1,  74,  88 ], # 2016 Spring
    'peachecho'           => [ 247, 120, 107,   6,  90,  69 ],
    'serenity'            => [ 145, 168, 208, 218,  40,  69 ],
    'snorkelblue'         => [   3,  79, 132, 205,  96,  26 ],
    'limpetshell'         => [ 152, 221, 222, 181,  51,  73 ],
    'lilacgrey'           => [ 152, 221, 222, 181,  51,  73 ],
    'icedcoffee'          => [ 177, 143, 106,  31,  31,  55 ],
    'fiesta'              => [ 221,  65,  50,   5,  72,  53 ],
    'buttercup'           => [ 221,  65,  50,   5,  72,  53 ],
    'greenflash'          => [ 250, 224,  60,  52,  95,  61 ],
    'riverside'           => [  76, 106, 146, 214,  32,  44 ], # Fall
    'airyblue'            => [ 146, 182, 213, 208,  44,  70 ],
    'sharkskin'           => [ 131, 132, 135, 225,   2,  52 ],
    'aurorared'           => [ 185,  58,  50,   4,  57,  46 ],
    'warmtaupe'           => [ 175, 148, 131,  23,  22,  60 ],
    'dustycedar'          => [ 173,  93,  93,   0,  33,  52 ],
    'lushmeadow'          => [   0, 110,  81, 164, 100,  22 ],
    'spicymustard'        => [ 216, 174,  71,  43,  65,  56 ],
    'pottersclay'         => [ 158,  70,  36,  17,  63,  38 ], # Potter's Clay
    'bodacious'           => [ 183, 107, 163, 316,  35,  57 ],
    'greenery'            => [ 146, 181,  88,  83,  39,  53 ], # 2017
    'niagara'             => [  87, 140, 169, 201,  32,  50 ],
    'primroseyellow'      => [ 246, 209,  85,  46,  90,  65 ],
    'lapisblue'           => [   0,  75, 141, 208, 100,  28 ],
    'flame'               => [ 242,  85,  44,  12,  88,  56 ],
    'islandparadise'      => [ 149, 222, 227, 184,  58,  74 ],
    'paledogwood'         => [ 237, 205, 194,  15,  54,  85 ],
    'pinkyarrow'          => [ 206,  49, 117, 334,  62,  50 ],
    'kale'                => [  90, 114,  71,  93,  23,  36 ],
    'hazelnut'            => [ 207, 176, 149,  28,  38,  70 ],
    'grenadine'           => [ 220,  76,  70,   2,  68,  57 ],
    'balletslipper'       => [ 243, 214, 228, 331,  55,  90 ],
    'butterum'            => [ 196, 143, 101,  27,  45,  58 ],
    'navypeony'           => [  34,  58,  94, 216,  47,  25 ],
    'neutralgray'         => [ 137, 142, 140, 156,   2,  55 ],
    'shadedspruce'        => [   0,  89,  96, 184, 100,  19 ],
    'goldenlime'          => [ 156, 154,  64,  59,  42,  43 ],
    'marina'              => [  79, 132, 196, 213,  50,  54 ],
    'autumnmaple'         => [ 210, 105,  30,  25,  75,  47 ],
    'meadowlark'          => [ 236, 219,  84,  53,  80,  63 ], # 2018
    'cherrytomato'        => [ 233,  75,  60,   5,  80,  57 ],
    'littleboyblue'       => [ 111, 159, 216, 213,  57,  64 ],
    'chilioil'            => [ 148,  71,  67,   3,  38,  42 ],
    'pinklavender'        => [ 219, 177, 205, 320,  37,  78 ],
    'bloomingdahlia'      => [ 236, 151, 135,  10,  73,  73 ],
    'arcadia'             => [   0, 165, 145, 173, 100,  32 ],
    'ultraviolet'         => [ 107,  91, 149, 257,  24,  47 ],
    'emperador'           => [ 108,  79,  61,  23,  28,  33 ],
    'almostmauve'         => [ 234, 222, 219,  12,  26,  89 ],
    'springcrocus'        => [ 188, 112, 164, 319,  36,  59 ],
    'sailorblue'          => [  46,  74,  98, 208,  36,  28 ],
    'harbormist'          => [ 180, 183, 186, 210,   4,  72 ],
    'warmsand'            => [ 192, 171, 142,  35,  28,  65 ],
    'coconutmilk'         => [ 240, 237, 229,  44,  27,  92 ],
    'redpear'             => [ 127,  65,  69, 356,  32,  38 ],
    'valiantpoppy'        => [ 189,  61,  58,   1,  53,  48 ],
    'nebulasblue'         => [  63, 105, 170, 216,  46,  46 ],
    'ceylonyellow'        => [ 213, 174,  65,  44,  64,  55 ],
    'martiniolive'        => [ 118, 111,  87,  46,  15,  40 ],
    'russetorange'        => [ 228, 122,  46,  25,  77,  54 ],
    'crocuspetal'         => [ 190, 158, 201, 285,  28,  70 ],
    'limelight'           => [ 241, 234, 127,  56,  80,  72 ],
    'quetzalgreen'        => [   0, 110, 109, 179, 100,  22 ],
    'sargassosea'         => [  72,  81, 103, 223,  18,  34 ],
    'tofu'                => [ 234, 230, 218,  45,  28,  89 ],
    'almondbuff'          => [ 209, 184, 148,  35,  40,  70 ],
    'quietgray'           => [ 188, 188, 190, 240,   2,  74 ],
    'meerkat'             => [ 169, 117,  79,  25,  36,  49 ],
    'fiesta'              => [ 221,  65,  50,   5,  72,  53 ], # 2019
    'jesterred'           => [ 158,  16,  48, 346,  82,  34 ],
    'turmeric'            => [ 254, 132,  14,  30,  99,  53 ],
    'livingcoral'         => [ 255, 111,  97,   5, 100,  69 ],
    'pinkpeacock'         => [ 198,  33, 104, 334,  71,  45 ],
    'pepperstem'          => [ 141, 148,  64,  65,  40,  42 ],
    'aspengold'           => [ 255, 214,  98,  44, 100,  69 ],
    'princessblue'        => [   0,  83, 156, 208, 100,  31 ],
    'toffee'              => [ 117,  81,  57,  24,  34,  34 ],
    'mangomojito'         => [ 214, 156,  47,  39,  67,  51 ],
    'terrariummoss'       => [  97,  98,  71,  62,  16,  33 ],
    'sweetlilac'          => [ 232, 181, 206, 331,  53,  81 ],
    'soybean'             => [ 210, 194, 157,  42,  37,  72 ],
    'eclipse'             => [  52,  49,  72, 248,  19,  24 ],
    'sweetcorn'           => [ 240, 234, 214,  46,  46,  89 ],
    'browngranite'        => [  97,  85,  80,  18,  10,  35 ],
    'chilipepper'         => [ 155,  27,  48, 350,  70,  36 ],
    'bikingred'           => [ 119,  33,  46, 351,  57,  30 ],
    'peachpink'           => [ 250, 154, 133,  11,  92,  75 ],
    'rockyroad'           => [  90,  62,  54,  13,  25,  28 ],
    'fruitdove'           => [ 206,  91, 120, 345,  54,  58 ],
    'sugaralmond'         => [ 147,  85,  41,  25,  56,  37 ],
    'darkcheddar'         => [ 224, 129,  25,  31,  80,  49 ],
    'galaxyblue'          => [  42,  75, 124, 216,  49,  33 ],
    'bluestone'           => [  87, 114, 132, 204,  21,  43 ],
    'orangetiger'         => [ 249, 103,  20,  22,  95,  53 ],
    'eden'                => [  38,  78,  54, 144,  34,  23 ],
    'vanillacustard'      => [ 243, 224, 190,  38,  69,  85 ],
    'eveningblue'         => [  42,  41,  62, 243,  20,  20 ],
    'paloma'              => [ 159, 156, 153,  30,   3,  61 ],
    'guacamole'           => [ 121, 123,  58,  62,  36,  35 ],
    'flamescarlet'        => [ 205,  33,  42, 357,  72,  47 ], # 2020
    'saffron'             => [ 255, 165,   0,  39, 100,  50 ],
    'biscaygreen'         => [  86, 198, 169, 164,  50,  56 ],
    'chive'               => [  75,  83,  53,  76,  22,  27 ],
    'fadeddenim'          => [ 121, 142, 164, 211,  19,  56 ],
    'orangepeel'          => [ 250, 122,  53,  21,  95,  59 ],
    'mosaicblue'          => [   0, 117, 143, 191, 100,  28 ],
    'sunlight'            => [ 237, 213, 158,  42,  69,  77 ],
    'coralpink'           => [ 232, 167, 152,  11,  63,  75 ],
    'grapecompote'        => [ 107,  88, 118, 278,  15,  40 ],
    'lark'                => [ 184, 155, 114,  35,  33,  58 ],
    'navyblazer'          => [  40,  45,  60, 225,  20,  20 ],
    'brilliantwhite'      => [ 237, 241, 255, 227, 100,  96 ],
    'ash'                 => [ 160, 153, 152,   8,   4,  61 ],
    'amberglow'           => [ 220, 121,  62,  22,  69,  55 ],
    'samba'               => [ 162,  36,  47, 355,  64,  39 ],
    'sandstone'           => [ 196, 138, 105,  22,  44,  59 ],
    'classicblue'         => [  52,  86, 139, 217,  46,  37 ],
    'greensheen'          => [ 217, 206,  82,  55,  64,  59 ],
    'rosetan'             => [ 209, 156, 151,   5,  39,  71 ],
    'ultramarinegreen'    => [   0, 107,  84, 167, 100,  21 ],
    'firedbrick'          => [ 106,  46,  42,   4,  43,  29 ],
    'peachnougat'         => [ 230, 175, 145,  21,  63,  74 ],
    'magentapurple'       => [ 108,  36,  76, 327,  50,  28 ],
    'marigold'            => [ 253, 172,  83,  31,  98,  66 ], # 2021
    'cerulean'            => [ 155, 183, 212, 211,  40,  72 ],
    'rust'                => [ 181,  90,  48,  19,  58,  45 ],
    'illuminating'        => [ 245, 223,  77,  52,  89,  63 ],
    'frenchblue'          => [   0, 114, 181, 202, 100,  35 ],
    'greenash'            => [ 160, 218, 169, 129,  44,  74 ],
    'burntcoral'          => [ 233, 137, 126,   6,  71,  70 ],
    'mint'                => [   0, 161, 112, 162, 100,  32 ],
    'amethystorchid'      => [ 146, 106, 166, 280,  25,  53 ],
    'raspberrysorbet'     => [ 210,  56, 108, 340,  63,  52 ],
    'inkwell'             => [  54,  57,  69, 228,  12,  24 ],
    'ultimategray'        => [ 147, 149, 151, 210,   2,  58 ],
    'buttercream'         => [ 239, 225, 206,  35,  51,  87 ],
    'desertmist'          => [ 224, 181, 137,  30,  58,  71 ],
    'willow'              => [ 154, 139,  79,  48,  32,  46 ],
);

our (@name_from_rgb, @name_from_hsl); # fill them through:

_add_color_to_reverse_search( $_, @{$rgbhsl_from_name{$_}} ) for all_names();


sub all_names  { sort keys %rgbhsl_from_name }
sub name_taken { exists  $rgbhsl_from_name{ _clean_name($_[0]) }}

sub rgb_from_name {
    my $name = _clean_name(shift);
    @{$rgbhsl_from_name{$name}}[0..2] if name_taken( $name );
}

sub hsl_from_name {
    my $name = _clean_name(shift);
    @{$rgbhsl_from_name{$name}}[3..5] if name_taken( $name );
}

sub name_from_rgb { 
    my (@rgb) = @_;
    @rgb  = @{$rgb[0]} if (ref $rgb[0] eq 'ARRAY');
    Chart::Color::Value::check_rgb( @rgb ) and return; # return if sub did carp
    my @names = _names_from_rgb( @rgb );
    wantarray ? @names : $names[0];
}

sub name_from_hsl { 
    my (@hsl) = @_;
    @hsl  = @{$hsl[0]} if (ref $hsl[0] eq 'ARRAY');
    Chart::Color::Value::check_hsl( @hsl ) and return;
    my @names = _names_from_hsl( @hsl );
    wantarray ? @names : $names[0];
}

sub names_in_hsl_range { # @center, (@d | $d) --> @names
    my $help = 'need two arguments: 1. array with h s l values '.
               '2. radius (real number) or array with tolerances in h s l direction';
    return carp  $help if @_ != 2;
    my ($hsl_center, $radius) = @_;
    return carp 'first argument has to be an array ref with thre number ([$h, $s, $l])'
        if ref $hsl_center ne 'ARRAY' or @$hsl_center != 3;
    return carp 'second argument has to be a integer < 180 or array ref with 3 integer'
        unless (ref $radius eq 'ARRAY' and @$radius == 3) or (defined $radius and not ref $radius);
    Chart::Color::Value::check_hsl( @$hsl_center ) and return;

    my @hsl_delta = ref $radius ? @$radius : ($radius, $radius, $radius);
    $hsl_delta[$_] = int abs $hsl_delta[$_] for 0 ..2;
    $hsl_delta[0] = 180 if $hsl_delta[0] > 180;        # enough to search complete HSL space (prevent double results)

    my (@min, @max, @names, $minhrange, $maxhrange);
    $min[$_] = $hsl_center->[$_] - $hsl_delta[$_]  for 0..2;
    $max[$_] = $hsl_center->[$_] + $hsl_delta[$_]  for 0..2;
    $min[1] =   0 if $min[1] <   0;
    $min[2] =   0 if $min[2] <   0;
    $max[1] = 100 if $max[1] > 100;
    $max[2] = 100 if $max[2] > 100;
    my @hrange = ($min[0] <   0 ?   0 : $min[0]) .. ($max[0] > 359 ? 359 : $max[0]);
    push @hrange, (360 + $min[0]) .. 359 if $min[0] <   0;
    push @hrange,  0 .. ($max[0] - 360) if $max[0] > 359;
    for my $h (@hrange){
        next unless defined $name_from_hsl[ $h ];
        for my $s ($min[1] .. $max[1]){
            next unless defined $name_from_hsl[ $h ][ $s ];
            for my $l ($min[2] .. $max[2]){
                my $name = $name_from_hsl[ $h ][ $s ][ $l ];
                next unless defined $name;
                push @names, (ref $name ? $name->[0] : $name);
             }
        }
    }
    @names = grep {Chart::Color::Value::distance_hsl( $hsl_center ,[hsl_from_name($_)] ) <= $radius} @names if not ref $radius;
    @names;
}

sub add_rgb {
    my ($name, @rgb) = @_;
    @rgb  = @{$rgb[0]} if (ref $rgb[0] eq 'ARRAY');
    return carp "missing first argument: color name" unless defined $name and $name;
    Chart::Color::Value::check_rgb( @rgb ) and return;
    _add_color( $name, @rgb, Chart::Color::Value::hsl_from_rgb( @rgb ) );
}

sub add_hsl {
    my ($name, @hsl) = @_;
    @hsl  = @{$hsl[0]} if (ref $hsl[0] eq 'ARRAY');
    return carp "missing first argument: color name" unless defined $name and $name;
    Chart::Color::Value::check_hsl( @hsl ) and return;
    _add_color( $name, Chart::Color::Value::rgb_from_hsl( @hsl ), @hsl );
}

sub _add_color {
    my ($name, @rgb, @hsl) = @_;
    $name = _clean_name( $name );
    return carp "there is already a color named '$name' in store of ".__PACKAGE__ if name_taken( $name );
    _add_color_to_reverse_search( $name, @rgb, @hsl);
    my $ret = $rgbhsl_from_name{$name} = [@rgb, @hsl]; # add to foreward search
    (ref $ret) ? [@$ret] : '';                         # make returned ref not transparent
}

sub _clean_name {
    my $name = shift;
    $name =~ tr/_//d;
    lc $name;
}

sub _names_from_rgb { # each of AoAoA cells (if exists) contains name or array with names (shortes first)
    return '' unless exists $name_from_rgb[ $_[0] ] 
              and exists $name_from_rgb[ $_[0] ][ $_[1] ] and exists $name_from_rgb[ $_[0] ][ $_[1] ][ $_[2] ];
    my $cell = $name_from_rgb[ $_[0] ][ $_[1] ][ $_[2] ];
    ref $cell ? @$cell : $cell;
}

sub _names_from_hsl { 
    return '' unless exists $name_from_hsl[ $_[0] ] 
              and exists $name_from_hsl[ $_[0] ][ $_[1] ] and exists $name_from_hsl[ $_[0] ][ $_[1] ][ $_[2] ];
    my $cell = $name_from_hsl[ $_[0] ][ $_[1] ][ $_[2] ];
    ref $cell ? @$cell : $cell;
}

sub _add_color_to_reverse_search { #     my ($name, @rgb, @hsl) = @_;
    my $name = $_[0];
    my $cell = $name_from_rgb[ $_[1] ][ $_[2] ][ $_[3] ];
    if (defined $cell) {
        if (ref $cell) {
            if (length $name < length $cell->[0] ) { unshift @$cell, $name }
            else                                   { push @$cell, $name    }
        } else {
            $name_from_rgb[ $_[1] ][ $_[2] ][ $_[3] ] = 
                (length $name < length $cell) ? [ $name, $cell ] 
                                              : [ $cell, $name ] ;
        }
    } else { $name_from_rgb[ $_[1] ][ $_[2] ][ $_[3] ] = $name  }
    
    $cell = $name_from_hsl[ $_[4] ][ $_[5] ][ $_[6] ];
    if (defined $cell) {
        if (ref $cell) {
            if (length $name < length $cell->[0] ) { unshift @$cell, $name }
            else                                   { push @$cell, $name    }
        } else {
            $name_from_hsl[ $_[4] ][ $_[5] ][ $_[6] ] = 
                (length $name < length $cell) ? [ $name, $cell ] 
                                              : [ $cell, $name ] ;
        }
    } else { $name_from_hsl[ $_[4] ][ $_[5] ][ $_[6] ] = $name  }
}

1;

__END__

=pod

=head1 NAME

Chart::Color::Constant - access values of color constants

=head1 SYNOPSIS 

    my @names = Chart::Color::Constant::all_names();
    my @rgb  = Chart::Color::Constant::rgb_from_name('darkblue');
    my @hsl  = Chart::Color::Constant::hsl_from_name('darkblue');
    
    Chart::Color::Value::add_rgb('lucky', [0, 100, 50]);

=head1 DESCRIPTION

RGB and HSL values of named colors from the X11 and HTML standard 
and Pantone report. Allows also reverse search, storage and conversion
of color values.

This module is supposed to be used by Chart::Color and not directly
by the user (for the most part). It converts a stored color name into
its values (rgb, hsl or both) and back. One color can have multiple names.
Also nearby (similar) colors can be searched. Own colors can be 
(none permanently) stored for later reference by name. For this a name
has to be chosen, that is not already taken. Independently of that
can any color be converted from rgb to hsl and back.

=head1 ROUTINES

=head2 rgb_from_name

Red, Green and Blue value of the named color. 
These values are integer in 0 .. 255.

    my @rgb = Chart::Color::Constant::rgb_from_name('darkblue');
    @rgb = Chart::Color::Constant::rgb_from_name('dark_blue'); # same result
    @rgb = Chart::Color::Constant::rgb_from_name('DarkBlue');  # still same

=head2 hsl_from_name

Hue, saturation and lightness of the named color. 
These are integer between 0 .. 359 (hue) or 100 (sat. & light.).
A hue of 360 and 0 (degree in a cylindrical coordinate system) is
considered to be the same, this modul deals only with the ladder.

    my @hsl = Chart::Color::Constant::hsl_from_name('darkblue');

=head2 name_from_rgb

Returns name of color with given rgb value triplet. 
Returns empty string if color is not stored. When several names define
given color, the shortest name will be selected in scalar context.
In array context all names are given.

    say Chart::Color::Constant::name_from_rgb( 15, 10, 121 );  # 'darkblue'
    say Chart::Color::Constant::name_from_rgb([15, 10, 121]);  # works too

=head2 name_from_hsl

Returns name of color with given hsl value triplet. 
Returns empty string if color is not stored. When several names define
given color, the shortest name will be selected in scalar context.
In array context all names are given.

    say scalar Chart::Color::Constant::name_from_hsl( 0, 100, 50 );  # 'red'
    scalar Chart::Color::Constant::name_from_hsl([0, 100, 50]);  # works too
    say for Chart::Color::Constant::name_from_hsl( 0, 100, 50 ); # 'red', 'red1'

=head2  names_in_hsl_range

Color names in selected neighbourhood of hsl color space, that look similar. 
It requires two arguments. The first one is an array containing three
values (hue, saturation and lightness), that define the center of the
neighbourhood (searched area).

The second argument can either be a number or again an array with
three values (h,s and l). If its just a number, it will be the radius r
of a ball, that defines the neighbourhood. From all colors inside that
ball, that are equal distanced or nearer to the center than r, one
name will returned.

If the second argument is an array, it has to contain the tolerance
(allowed distance) in h, s and l direction. Please note the h dimension
is circular: the distance from 355 to 0 is 5. The s and l dimensions are
linear, so that a center value of 90 and a tolerance of 15 will result
in a search of in the range 75 .. 100.

The results contains only one name per color (the shortest).

    # all bright red'ish clors
    my @names = Chart::Color::Constant::names_in_hsl_range([0, 90, 50], 5);
    # approximates to : 
    my @names = Chart::Color::Constant::names_in_hsl_range([0, 90, 50],[ 3, 3, 3]);


=head2 all_names

A sorted list of all stored color names.

=head2 name_taken

A perlish pseudo boolean tells if the color name is already in use.

=head2 add_rgb

Adding a color to the store under an not taken (not already used) name.
Arguments are name, red, green and blue value (integer < 256, see rgb).

    Chart::Color::Constant::add_rgb('nightblue',  15, 10, 121 );
    Chart::Color::Constant::add_rgb('nightblue', [15, 10, 121]);

=head2 add_hsl

Adding a color to the store under an not taken (not already used) name.
Arguments are name, hue, saturation and lightness value (see hsl).

    Chart::Color::Constant::add_rgb('lucky',  0, 100, 50 );
    Chart::Color::Constant::add_rgb('lucky', [0, 100, 50]);

=head2 NAMES

white, black, red, green, blue, yellow, purple, pink, peach, plum, mauve, brown, grey  

aliceblue, antiquewhite, antiquewhite1, antiquewhite2, antiquewhite3, 
antiquewhite4, aqua, aquamarine, aquamarine1, aquamarine2, aquamarine3,
aquamarine4, azure, azure1, azure2, azure3, azure4, beige, bisque, bisque1,
bisque2, bisque3, bisque4, blanchedalmond, blue1, blue2, blue3, blue4,
blueviolet, brown1, brown2, brown3, brown4, burlywood, burlywood1, 
burlywood2, burlywood3, burlywood4, cadetblue, cadetblue1, cadetblue2,
cadetblue3, cadetblue4, chartreuse, chartreuse1, chartreuse2, chartreuse3,
chartreuse4, chocolate, chocolate1, chocolate2, chocolate3, chocolate4,
coral, coral1, coral2, coral3, coral4, cornflowerblue, cornsilk, cornsilk1,
cornsilk2, cornsilk3, cornsilk4, crimson, cyan, cyan1, cyan2, cyan3, cyan4,
darkblue, darkcyan, darkgoldenrod, darkgoldenrod1, darkgoldenrod2, 
darkgoldenrod3, darkgoldenrod4, darkgray, darkgreen, darkkhaki, darkmagenta,
darkolivegreen, darkolivegreen1, darkolivegreen2, darkolivegreen3, 
darkolivegreen4, darkorange, darkorange1, darkorange2, darkorange3, 
darkorange4, darkorchid, darkorchid1, darkorchid2, darkorchid3, 
darkorchid4, darkred, darksalmon, darkseagreen, darkseagreen1, 
darkseagreen2, darkseagreen3, darkseagreen4, darkslateblue, darkslategray,
darkslategray1, darkslategray2, darkslategray3, darkslategray4, 
darkturquoise, darkviolet, deeppink, deeppink1, deeppink2, deeppink3,
deeppink4, deepskyblue, deepskyblue1, deepskyblue2,  deepskyblue3,
deepskyblue4, dimgray, dodgerblue, dodgerblue1, dodgerblue2, dodgerblue3,
dodgerblue4, firebrick, firebrick1, firebrick2, firebrick3, firebrick4,
floralwhite, forestgreen, fuchsia, gainsboro, ghostwhite, gold, gold1,
gold2, gold3, gold4, goldenrod, goldenrod1, goldenrod2, goldenrod3,
goldenrod4, gray, gray1, gray2, gray3, gray4, gray5, gray6, gray7, gray8,
gray9, gray10, gray11, gray12, gray13, gray14, gray15, gray16, gray17,
gray18, gray19, gray20, gray21, gray22, gray23, gray24, gray25, gray26,
gray27, gray28, gray29, gray30, gray31, gray32, gray33, gray34, gray35,
gray36, gray37, gray38, gray39, gray40, gray41, gray42, gray43, gray44,
gray45, gray46, gray47, gray48, gray49, gray50, gray51, gray52, gray53,
gray54, gray55, gray56, gray57, gray58, gray59, gray60, gray61, gray62,
gray63, gray64, gray65, gray66, gray67, gay68,  gray69, gray70, gray71,
gray72, gray73, gray74, gray75, gray76, gray77, gray78, gray79, gray80,
gray81, gray82, gray83, gray84, gray85, gray86, gray87, gray88, gray89,
gray90, gray91, gray92, gray93, gray94, gray95, gray97, gray98, gray99,
green1, green2, green3, green4, greenyellow, grey1, grey2, grey3, grey4,
honeydew, honeydew1, honeydew2, honeydew3, honeydew4, hotpink, hotpink1,
hotpink2, hotpink3, hotpink4, indianred, indianred1, indianred2, indianred3,
indianred4, indigo, ivory, ivory1, ivory2, ivory3, ivory4, khaki, khaki1,
khaki2, khaki3, khaki4, lavender, lavenderblush,  lavenderblush1, 
lavenderblush2, lavenderblush3, lavenderblush4, lawngreen, lemonchiffon,
lemonchiffon1, lemonchiffon2, lemonchiffon3, lemonchiffon4, light,
lightblue, lightblue1, lightblue2, lightblue3,lightblue4, lightcoral,
lightcyan, lightcyan1, lightcyan2, lightcyan3, lightcyan4, lightgoldenrod,
lightgoldenrod1, lightgoldenrod2, lightgoldenrod3, lightgoldenrod4,
lightgray, lightgreen, lightpink, lightpink1, lightpink2, lightpink3,
lightpink4, lightpurple, lightsalmon, lightsalmon1, lightsalmon2, 
lightsalmon3, lightsalmon4, lightseagreen, lightskyblue, lightskyblue1,
lightskyblue2, lightskyblue3, lightskyblue4, lightslateblue, lightslategray,
lightsteelblue, lightsteelblue1, lightsteelblue2, lightsteelblue3,
lightsteelblue4, lightyellow, lightyellow1, lightyellow2, lightyellow3,
lightyellow4, lime, limegreen, linen, magenta, magenta1, magenta2, magenta3,
magenta4, maroon, maroon1,  maroon2, maroon3, maroon4, medium,
mediumaquamarine, mediumblue, mediumorchid, mediumorchid1, mediumorchid2,
mediumorchid3, mediumorchid4, mediumpurple, mediumpurple1, mediumpurple2,
mediumpurple3, mediumpurple4, mediumseagreen, mediumslateblue,
mediumspringgreen, mediumturquoise, mediumvioletred, midnightblue,
mintcream, mistyrose, mistyrose1, mistyrose2, mistyrose3, mistyrose4,
moccasin, navajowhite, navajowhite1, navajowhite2, navajowhite3, 
navajowhite4, navy, navyblue, oldlace, olive, olivedrab, olivedrab1,
olivedrab2, olivedrab3, olivedrab4, orange, orange1, orange2, orange3,
orange4, orangered, orangered1, orangered2, orangered3, orangered4,
orchid, orchid1, orchid2, orchid3, orchid4, pale, palegoldenrod, palegreen,
palegreen1, palegreen2, palegreen3, palegreen4, paleturquoise,
paleturquoise1, paleturquoise2, paleturquoise3, paleturquoise4,
palevioletred, palevioletred1, palevioletred2, palevioletred3,
palevioletred4, papayawhip, peachpuff, peachpuff1, peachpuff2, peachpuff3,
peachpuff4, peru, pink1, pink2, pink3, pink4, plum1, plum2, plum3, plum4,
powderblue, purple1, purple2, purple3, purple4, rebeccapurple, red1, red2,
red3, red4, rosybrown, rosybrown1, rosybrown2, rosybrown3, rosybrown4,  
royalblue, royalblue1, royalblue2, royalblue3, royalblue4, saddlebrown,
salmon, salmon1, salmon2, salmon3, salmon4, sandybrown, seagreen,
seagreen1, seagreen2, seagreen3, seagreen4, seashell, seashell1, seashell2,
seashell3, seashell4, sienna, sienna1, sienna2, sienna3, sienna4, silver,
skyblue, skyblue1, skyblue2, skyblue3, skyblue4, slateblue, slateblue1,
slateblue2, slateblue3, slateblue4, slategray, slategray1, slategray2,
slategray3, slategray4, snow, snow1, snow2, snow3, snow4, springgreen,
springgreen1, springgreen2, springgreen3, springgreen4, steelblue, 
steelblue1, steelblue2, steelblue3, steelblue4, tan, tan1, tan2, tan3,
tan4, teal, thistle, thistle1, thistle2, thistle3, thistle4, tomato,
tomato1, tomato2, tomato3, tomato4, turquoise, turquoise1, turquoise2, 
turquoise3, turquoise4, violet, violetred, violetred1, violetred2, 
violetred3, violetred4, wheat, wheat1, wheat2, wheat3, wheat4, whitesmoke,
yellow1, yellow2, yellow3, yellow4, yellowgreen

marsala, radiandorchid, emerald, tangerinetango, honeysucle, turquoise, 
mimosa, blueizis, chilipepper, sanddollar, blueturquoise, tigerlily,
aquasky, truered, fuchsiarose, ceruleanblue, rosequartz, peachecho,
serenity, snorkelblue, limpetshell, lilacgrey, icedcoffee, fiesta,
buttercup, greenflash, riverside, airyblue, sharkskin, aurorared,
warmtaupe, dustycedar, lushmeadow, spicymustard, pottersclay, bodacious,
greenery, niagara, primroseyellow, lapisblue, flame, islandparadise,
paledogwood, pinkyarrow, kale, hazelnut, grenadine, balletslipper,
butterum, navypeony, neutralgray, shadedspruce, goldenlime, marina,
autumnmaple, meadowlark, cherrytomato, littleboyblue, chilioil, 
pinklavender, bloomingdahlia, arcadia, ultraviolet, emperador, 
almostmauve, springcrocus, sailorblue, harbormist, warmsand, coconutmilk,
redpear, valiantpoppy, nebulasblue,  ceylonyellow, martiniolive,
russetorange, crocuspetal, limelight, quetzalgreen, sargassosea, tofu, 
almondbuff, quietgray, meerkat, fiesta, jesterred, turmeric, livingcoral, 
pinkpeacock, pepperstem, aspengold, princessblue, toffee, mangomojito, 
terrariummoss, sweetlilac, soybean, eclipse, sweetcorn, browngranite, 
chilipepper, bikingred, peachpink, rockyroad, fruitdove, sugaralmond, 
darkcheddar, galaxyblue, bluestone, orangetiger, eden, vanillacustard,
eveningblue, paloma, guacamole, flamescarlet, saffron, biscaygreen, chive,
fadeddenim,   orangepeel, mosaicblue, sunlight, coralpink, grapecompote,
lark, navyblazer, brilliantwhite, ash, amberglow, samba, sandstone,
classicblue, greensheen, rosetan, ultramarinegreen, firedbrick,
peachnougat, magentapurple, marigold, cerulean, rust, illuminating,
frenchblue, greenash, burntcoral, mint, amethystorchid, raspberrysorbet,
inkwell, ultimategray, buttercream, desertmist, willow

=for HTML <p>
<img src="https://raw.githubusercontent.com/lichtkind/Chart/main/dev/function/color/table/color_table0.png" alt="color table 1">
<img src="https://raw.githubusercontent.com/lichtkind/Chart/main/dev/function/color/table/color_table1.png" alt="color table 2">
<img src="https://raw.githubusercontent.com/lichtkind/Chart/main/dev/function/color/table/color_table2.png" alt="color table 3">
<img src="https://raw.githubusercontent.com/lichtkind/Chart/main/dev/function/color/table/color_table3.png" alt="color table 4">
</p>

=head1 COPYRIGHT & LICENSE

Copyright 2022 Herbert Breunung.

This program is free software; you can redistribute it and/or modify it 
under same terms as Perl itself.

=head1 AUTHOR

Herbert Breunung, <lichtkind@cpan.org>
