package STR::OTVC;

use strict;
require Exporter;
our @ISA         = ('Exporter');
our @EXPORT      = qw(vcode);
our $VERSION     = '1.0';

sub vcode {

my ($j, $m, $y, $k, $t, $h);
# Small And Caps Letters
my @chars = ("a A b B c C d D e E f  F g G h H i I j J k K l L m
     M n N o O p P q Q r R s S t T u U v V w W x X y Y z Z");
foreach $j (@chars) {
 $m = $j;
}

# Special Characters
my @special_char = (" @ # = %  & *  - +  ? ");
foreach $t (@special_char) {
 $h = $t;
}

# Numbers
my @num = ("1 2 3 4 5 6 7 8 9 0");
foreach $y (@num) {
 $k = $y;
}

# Default Lengith 
my $Random_len = 6;

my ($int_rnd, $rnd_int);
my @Gen  = split(" ", 
                        "$h $k $m");
                         srand;

for (my $rnd = 0; $rnd < $Random_len; $rnd ++) {
     $int_rnd = int (rand 50);
     $rnd_int .= $Gen[$int_rnd];
}
return $rnd_int;
}
vcode();

1;

__END__

=head1 NAME

STR::OTVC - One-Time Verification Code Generator

=head1 SYNOPSIS

    use STR::OTVC qw(vcode);
    print vcode();
    
=head1 ABSTRACT

This Perl Library Defines A Single Function, C<vcode()>, to Generate 
One-Time Verification Codes
The function is meant to be a simple way for
developers and system administrators to easily generate a relatively
One-Time Verification Codes 

=head1 DESCRIPTION

The exportable C<vcode()> function returns a single scalar: A Verification Codes.
By default, these Verification Codes are six characters long with a lower-case, upper-case,
digits, and special characters

=head2 EXCEPTION HANDLING

By default, C<vcode()> will return C<undef> if it cannot generate
Verification Codes.

=head2 EXPORT
None by default.  The C<vcode()> method is exportable.

=head1 AUTHOR
SSENYONJJO NATHAN  E<lt>kingn@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE
Copyright (C) 2015-2016 by SSENYONJJO NATHAN

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself, either Perl version 5.010 or, at
your option, any later version of Perl 5 you may have available.

=cut




