#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Literal__String__VAR_EXPANSION1 = -1;
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Minimal__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__x = -1;
// Sub id declarations
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__String__characters(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__String__edge_case(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__String__escape(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__String__escape_ascii(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__String__escape_unicode(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Literal__String__var_expansion(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Literal__String__characters(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "characters";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 34;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L6: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L104;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L13: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "characters";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L15: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L16: // MOVE_CONSTANT_BYTE
  byte_vars[1] = '\x61';
L17: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[1];
L18: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "characters";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L24: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L25: // MOVE_CONSTANT_BYTE
  byte_vars[1] = '\x62';
L26: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L27: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[2];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[3];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[4];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L55; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L41: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "characters";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L43: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L44: // MOVE_CONSTANT_BYTE
  byte_vars[1] = '\x63';
L45: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L46: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L52; }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L50: // BOOL_INT
  int_vars[0] = int_vars[2];
L51: // GOTO
  goto L54;
L52: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L53: // BOOL_INT
  int_vars[0] = int_vars[3];
L54: // GOTO
  goto L57;
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L56: // BOOL_INT
  int_vars[0] = int_vars[4];
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_NE_ZERO
  if (int_vars[0]) { goto L62; }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L104;
L61: // GOTO
  goto L62;
L62: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L65: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x0A\x63\x64\x0A", 6));
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L67: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[4]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], string);
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L69: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "characters";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 49;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L72: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x0A\x65\x66", 3));
L73: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L74: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string3);
    }
  }
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "characters";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 46;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L76: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L77: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L78: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L81: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x0A\x63\x64\x0A\x35\x0A\x65\x66", 10));
L82: // STRING_EQ
  {
    void* object1 = object_vars[4];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "characters";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L104;
  }
L84: // BOOL_INT
  int_vars[0] = int_vars[0];
L85: // IF_NE_ZERO
  if (int_vars[0]) { goto L90; }
L86: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L87: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L88: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L104;
L89: // GOTO
  goto L90;
L90: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L91: // MOVE_CONSTANT_INT
  int_vars[5] = 56;
L92: // MOVE_CONSTANT_INT
  int_vars[6] = 56;
L93: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_NE_ZERO
  if (int_vars[0]) { goto L99; }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L104;
L98: // GOTO
  goto L99;
L99: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L100: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L101: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L104;
L102: // INIT_INT
  int_vars[6] = 0;
L103: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L104;
L104: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L105: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__String__edge_case(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x61\x61\x61\x5C", 5));
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "edge_case";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 12;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L6: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L7: // MOVE_CONSTANT_BYTE
  byte_vars[1] = '\x5C';
L8: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L9: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L14: // GOTO
  goto L15;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L17: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x61\x61\x61\x24", 5));
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L19: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "edge_case";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L21: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L22: // MOVE_CONSTANT_BYTE
  byte_vars[1] = '\x24';
L23: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L24: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L29: // GOTO
  goto L30;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__String__escape(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x00\x07\x08\x09\x0A\x0C\x0D\x22\x27\x5C\x7A", 12));
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 70;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L6: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L15: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L17: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 7;
L19: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L24: // GOTO
  goto L25;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L26: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 80;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L28: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 8;
L30: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L35: // GOTO
  goto L36;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L37: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 85;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L39: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 9;
L41: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_NE_ZERO
  if (int_vars[0]) { goto L47; }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L46: // GOTO
  goto L47;
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L48: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 90;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L50: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L51: // MOVE_CONSTANT_INT
  int_vars[6] = 10;
L52: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_NE_ZERO
  if (int_vars[0]) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L57: // GOTO
  goto L58;
L58: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L59: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L61: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L62: // MOVE_CONSTANT_INT
  int_vars[6] = 12;
L63: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L68: // GOTO
  goto L69;
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 7;
L70: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 100;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L72: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L73: // MOVE_CONSTANT_INT
  int_vars[6] = 13;
L74: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_NE_ZERO
  if (int_vars[0]) { goto L80; }
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L78: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L79: // GOTO
  goto L80;
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 8;
L81: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L83: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L84: // MOVE_CONSTANT_INT
  int_vars[6] = 34;
L85: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L86: // BOOL_INT
  int_vars[0] = int_vars[0];
L87: // IF_NE_ZERO
  if (int_vars[0]) { goto L91; }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L89: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L90: // GOTO
  goto L91;
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 9;
L92: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 110;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L94: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L95: // MOVE_CONSTANT_INT
  int_vars[6] = 39;
L96: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_NE_ZERO
  if (int_vars[0]) { goto L102; }
L99: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L101: // GOTO
  goto L102;
L102: // MOVE_CONSTANT_INT
  int_vars[4] = 10;
L103: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 115;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L105: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L106: // MOVE_CONSTANT_INT
  int_vars[6] = 92;
L107: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L108: // BOOL_INT
  int_vars[0] = int_vars[0];
L109: // IF_NE_ZERO
  if (int_vars[0]) { goto L113; }
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L112: // GOTO
  goto L113;
L113: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L117;
L115: // INIT_INT
  int_vars[6] = 0;
L116: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L117;
L117: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L118: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__String__escape_ascii(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x00\x11\x22\x33\x44\x55\x66\x77\x78\x79\x7A\x7B\x7C\x7D\x7E\x7F\x7A\x7B\x7C\x7D\x7E\x7F\x61", 23));
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L4: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L6: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L15: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L17: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 17;
L19: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L24: // GOTO
  goto L25;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L26: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L28: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L29: // MOVE_CONSTANT_INT
  int_vars[6] = 34;
L30: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L35: // GOTO
  goto L36;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L37: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L39: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 51;
L41: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_NE_ZERO
  if (int_vars[0]) { goto L47; }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L46: // GOTO
  goto L47;
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L48: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L50: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L51: // MOVE_CONSTANT_INT
  int_vars[6] = 68;
L52: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_NE_ZERO
  if (int_vars[0]) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L57: // GOTO
  goto L58;
L58: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L59: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 145;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L61: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L62: // MOVE_CONSTANT_INT
  int_vars[6] = 85;
L63: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L68: // GOTO
  goto L69;
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L70: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L72: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L73: // MOVE_CONSTANT_INT
  int_vars[6] = 102;
L74: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_NE_ZERO
  if (int_vars[0]) { goto L80; }
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L78: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L79: // GOTO
  goto L80;
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 7;
L81: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 153;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L83: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L84: // MOVE_CONSTANT_INT
  int_vars[6] = 119;
L85: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L86: // BOOL_INT
  int_vars[0] = int_vars[0];
L87: // IF_NE_ZERO
  if (int_vars[0]) { goto L91; }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L89: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L90: // GOTO
  goto L91;
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 8;
L92: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 157;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L94: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L95: // MOVE_CONSTANT_INT
  int_vars[6] = 120;
L96: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_NE_ZERO
  if (int_vars[0]) { goto L102; }
L99: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L101: // GOTO
  goto L102;
L102: // MOVE_CONSTANT_INT
  int_vars[4] = 9;
L103: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L105: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L106: // MOVE_CONSTANT_INT
  int_vars[6] = 121;
L107: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L108: // BOOL_INT
  int_vars[0] = int_vars[0];
L109: // IF_NE_ZERO
  if (int_vars[0]) { goto L113; }
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L112: // GOTO
  goto L113;
L113: // MOVE_CONSTANT_INT
  int_vars[4] = 10;
L114: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 165;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L116: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L117: // MOVE_CONSTANT_INT
  int_vars[6] = 122;
L118: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L119: // BOOL_INT
  int_vars[0] = int_vars[0];
L120: // IF_NE_ZERO
  if (int_vars[0]) { goto L124; }
L121: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L123: // GOTO
  goto L124;
L124: // MOVE_CONSTANT_INT
  int_vars[4] = 11;
L125: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L126: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 169;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L127: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L128: // MOVE_CONSTANT_INT
  int_vars[6] = 123;
L129: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L130: // BOOL_INT
  int_vars[0] = int_vars[0];
L131: // IF_NE_ZERO
  if (int_vars[0]) { goto L135; }
L132: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L133: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L134: // GOTO
  goto L135;
L135: // MOVE_CONSTANT_INT
  int_vars[4] = 12;
L136: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L137: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L138: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L139: // MOVE_CONSTANT_INT
  int_vars[6] = 124;
L140: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L141: // BOOL_INT
  int_vars[0] = int_vars[0];
L142: // IF_NE_ZERO
  if (int_vars[0]) { goto L146; }
L143: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L144: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L145: // GOTO
  goto L146;
L146: // MOVE_CONSTANT_INT
  int_vars[4] = 13;
L147: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L148: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 177;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L149: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L150: // MOVE_CONSTANT_INT
  int_vars[6] = 125;
L151: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L152: // BOOL_INT
  int_vars[0] = int_vars[0];
L153: // IF_NE_ZERO
  if (int_vars[0]) { goto L157; }
L154: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L155: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L156: // GOTO
  goto L157;
L157: // MOVE_CONSTANT_INT
  int_vars[4] = 14;
L158: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L159: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 181;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L160: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L161: // MOVE_CONSTANT_INT
  int_vars[6] = 126;
L162: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L163: // BOOL_INT
  int_vars[0] = int_vars[0];
L164: // IF_NE_ZERO
  if (int_vars[0]) { goto L168; }
L165: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L166: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L167: // GOTO
  goto L168;
L168: // MOVE_CONSTANT_INT
  int_vars[4] = 15;
L169: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L170: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L171: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L172: // MOVE_CONSTANT_INT
  int_vars[6] = 127;
L173: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L174: // BOOL_INT
  int_vars[0] = int_vars[0];
L175: // IF_NE_ZERO
  if (int_vars[0]) { goto L179; }
L176: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L177: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L178: // GOTO
  goto L179;
L179: // MOVE_CONSTANT_INT
  int_vars[4] = 16;
L180: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L181: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L182: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L183: // MOVE_CONSTANT_INT
  int_vars[6] = 122;
L184: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L185: // BOOL_INT
  int_vars[0] = int_vars[0];
L186: // IF_NE_ZERO
  if (int_vars[0]) { goto L190; }
L187: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L188: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L189: // GOTO
  goto L190;
L190: // MOVE_CONSTANT_INT
  int_vars[4] = 17;
L191: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L192: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 193;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L193: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L194: // MOVE_CONSTANT_INT
  int_vars[6] = 123;
L195: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L196: // BOOL_INT
  int_vars[0] = int_vars[0];
L197: // IF_NE_ZERO
  if (int_vars[0]) { goto L201; }
L198: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L199: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L200: // GOTO
  goto L201;
L201: // MOVE_CONSTANT_INT
  int_vars[4] = 18;
L202: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L203: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L204: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L205: // MOVE_CONSTANT_INT
  int_vars[6] = 124;
L206: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L207: // BOOL_INT
  int_vars[0] = int_vars[0];
L208: // IF_NE_ZERO
  if (int_vars[0]) { goto L212; }
L209: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L210: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L211: // GOTO
  goto L212;
L212: // MOVE_CONSTANT_INT
  int_vars[4] = 19;
L213: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L214: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 201;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L215: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L216: // MOVE_CONSTANT_INT
  int_vars[6] = 125;
L217: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L218: // BOOL_INT
  int_vars[0] = int_vars[0];
L219: // IF_NE_ZERO
  if (int_vars[0]) { goto L223; }
L220: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L221: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L222: // GOTO
  goto L223;
L223: // MOVE_CONSTANT_INT
  int_vars[4] = 20;
L224: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L225: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L226: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L227: // MOVE_CONSTANT_INT
  int_vars[6] = 126;
L228: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L229: // BOOL_INT
  int_vars[0] = int_vars[0];
L230: // IF_NE_ZERO
  if (int_vars[0]) { goto L234; }
L231: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L232: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L233: // GOTO
  goto L234;
L234: // MOVE_CONSTANT_INT
  int_vars[4] = 21;
L235: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L236: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L237: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L238: // MOVE_CONSTANT_INT
  int_vars[6] = 127;
L239: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L240: // BOOL_INT
  int_vars[0] = int_vars[0];
L241: // IF_NE_ZERO
  if (int_vars[0]) { goto L245; }
L242: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L243: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L244: // GOTO
  goto L245;
L245: // MOVE_CONSTANT_INT
  int_vars[4] = 22;
L246: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L247: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_ascii";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 213;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L248: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L249: // MOVE_CONSTANT_BYTE
  byte_vars[1] = '\x61';
L250: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[1];
L251: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L252: // BOOL_INT
  int_vars[0] = int_vars[0];
L253: // IF_NE_ZERO
  if (int_vars[0]) { goto L257; }
L254: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L255: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L256: // GOTO
  goto L257;
L257: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L258: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L261;
L259: // INIT_INT
  int_vars[6] = 0;
L260: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L261;
L261: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L262: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__String__escape_unicode(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\xE3\x81\x82\xE3\x81\x84\xE3\x81\x86", 9));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\xE3\x81\x82\xE3\x81\x84\xE3\x81\x86", 9));
L5: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "escape_unicode";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 223;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L12: // GOTO
  goto L13;
L13: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L18;
L16: // INIT_INT
  int_vars[6] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L18;
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Literal__String__var_expansion(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[13] = {0};
  void* ref_vars[1] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[72];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x20", 2));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[1]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], string);
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 237;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L11: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x20\x62\x20", 3));
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L13: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string3);
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 237;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L16: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[3]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string);
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L18: // CONCAT
  {
    void* string1 = object_vars[4];
    void* string2 = object_vars[5];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string3);
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 237;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L21: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], env->new_string_len_raw(env, "\x63\x20", 2));
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L23: // CONCAT
  {
    void* string1 = object_vars[6];
    void* string2 = object_vars[7];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], string3);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 237;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L26: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[1]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], string);
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L28: // CONCAT
  {
    void* string1 = object_vars[8];
    void* string2 = object_vars[9];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], string3);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 237;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], env->new_string_len_raw(env, "\x2D\x3E\x32", 3));
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 12;
  mortal_stack_top++;
L33: // CONCAT
  {
    void* string1 = object_vars[10];
    void* string2 = object_vars[11];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], string3);
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 237;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L35: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], NULL);
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], NULL);
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], NULL);
L38: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L39: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L41: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L46: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L48: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x20\x31\x20\x62\x20\x32\x63\x20\x31\x2D\x3E\x32", 13));
L49: // STRING_EQ
  {
    void* object1 = object_vars[12];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 239;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L53: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L54: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L347;
L56: // GOTO
  goto L57;
L57: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 13;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L58: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L60: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x45\x72\x72\x6F\x72", 5));
L61: // SET_EXCEPTION_VAR
  env->set_exception(env, object_vars[0]);
L62: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L64: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x20", 2));
L65: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L66: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->get_exception(env));
L67: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L68: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L71: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x62\x20", 2));
L72: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L73: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string3);
    }
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L75: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L76: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->get_exception(env));
L77: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L78: // CONCAT
  {
    void* string1 = object_vars[4];
    void* string2 = object_vars[5];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string3);
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L81: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], env->new_string_len_raw(env, "\x63", 1));
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L83: // CONCAT
  {
    void* string1 = object_vars[6];
    void* string2 = object_vars[7];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], string3);
    }
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L85: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L86: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L87: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L88: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L89: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L90: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L92: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L93: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L94: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x20\x45\x72\x72\x6F\x72\x62\x20\x45\x72\x72\x6F\x72\x63", 15));
L95: // STRING_EQ
  {
    void* object1 = object_vars[8];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_NE_ZERO
  if (int_vars[0]) { goto L103; }
L99: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L100: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L101: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L347;
L102: // GOTO
  goto L103;
L103: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L104: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L107: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L108: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L109: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x20", 2));
L110: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[0];
L111: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L112: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[3]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], string);
  }
L113: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L114: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 261;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L116: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L117: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x20\x62\x20", 3));
L118: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L119: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string3);
    }
  }
L120: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 261;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L121: // GET_DEREF_INT
  int_vars[4] = *(int32_t*)*(void**)&ref_vars[0];
L122: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L123: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[4]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string);
  }
L124: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L125: // CONCAT
  {
    void* string1 = object_vars[4];
    void* string2 = object_vars[5];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string3);
    }
  }
L126: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 261;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L127: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L128: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], env->new_string_len_raw(env, "\x63", 1));
L129: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L130: // CONCAT
  {
    void* string1 = object_vars[6];
    void* string2 = object_vars[7];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], string3);
    }
  }
L131: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 261;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L132: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L133: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L134: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L135: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L136: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L137: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L138: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L139: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L140: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L141: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x20\x35\x20\x62\x20\x35\x63", 8));
L142: // STRING_EQ
  {
    void* object1 = object_vars[8];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L143: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L144: // BOOL_INT
  int_vars[0] = int_vars[0];
L145: // IF_NE_ZERO
  if (int_vars[0]) { goto L150; }
L146: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L147: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L148: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L347;
L149: // GOTO
  goto L150;
L150: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L151: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L152: // MOVE_CONSTANT_INT
  int_vars[2] = 6;
L153: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Literal__String__VAR_EXPANSION1 < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Literal__String__VAR_EXPANSION1 = env->get_package_var_id(env, "TestCase::Literal::String", "$VAR_EXPANSION1", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Literal__String__VAR_EXPANSION1 < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Literal::String $VAR_EXPANSION1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Literal__String__VAR_EXPANSION1] = int_vars[2];
  }
L154: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L155: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x20", 2));
L156: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Literal__String__VAR_EXPANSION1 < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Literal__String__VAR_EXPANSION1 = env->get_package_var_id(env, "TestCase::Literal::String", "$VAR_EXPANSION1", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Literal__String__VAR_EXPANSION1 < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Literal::String $VAR_EXPANSION1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Literal__String__VAR_EXPANSION1];
  }
L157: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L158: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], string);
  }
L159: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L160: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L161: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L162: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L163: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x20\x62", 2));
L164: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L165: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string3);
    }
  }
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L167: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L168: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L169: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L170: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L171: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L172: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x20\x36\x20\x62", 5));
L173: // STRING_EQ
  {
    void* object1 = object_vars[4];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L174: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L175: // BOOL_INT
  int_vars[0] = int_vars[0];
L176: // IF_NE_ZERO
  if (int_vars[0]) { goto L181; }
L177: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L178: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L179: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L347;
L180: // GOTO
  goto L181;
L181: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L182: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L183: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L184: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L185: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L186: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 281;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L187: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L188: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L189: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L190: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 281;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L191: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L192: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L193: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L194: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 281;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L195: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L196: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L197: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[9];
      } 
    } 
  } 
L198: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 281;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L199: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L200: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L201: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L202: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L203: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L204: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 282;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L205: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L206: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L207: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 283;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L208: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L209: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x20", 2));
L210: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L211: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L212: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L213: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L214: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[3]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string);
  }
L215: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L216: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string3);
    }
  }
L217: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L218: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L219: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x62\x20", 2));
L220: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L221: // CONCAT
  {
    void* string1 = object_vars[4];
    void* string2 = object_vars[5];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string3);
    }
  }
L222: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L223: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L224: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L225: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L226: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[4]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string);
  }
L227: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L228: // CONCAT
  {
    void* string1 = object_vars[6];
    void* string2 = object_vars[7];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], string3);
    }
  }
L229: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L230: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L231: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], env->new_string_len_raw(env, "\x63", 1));
L232: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L233: // CONCAT
  {
    void* string1 = object_vars[8];
    void* string2 = object_vars[9];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], string3);
    }
  }
L234: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 285;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L235: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], NULL);
L236: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L237: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L238: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L239: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L240: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L241: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L242: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L243: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L244: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x20\x32\x62\x20\x35\x63", 7));
L245: // STRING_EQ
  {
    void* object1 = object_vars[10];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L246: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 287;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L247: // BOOL_INT
  int_vars[0] = int_vars[0];
L248: // IF_NE_ZERO
  if (int_vars[0]) { goto L253; }
L249: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L250: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L251: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L347;
L252: // GOTO
  goto L253;
L253: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 12;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L254: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L255: // MOVE_CONSTANT_INT
  int_vars[4] = 11;
L256: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L257: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L258: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L259: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L260: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L261: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L262: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L263: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L264: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L265: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L266: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L267: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L268: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L269: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 296;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L270: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L271: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 296;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L272: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L273: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L274: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L275: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L276: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L277: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 298;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L278: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L279: // MOVE_CONSTANT_INT
  int_vars[2] = 11;
L280: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L281: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L282: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L283: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 299;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L284: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L285: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 299;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L286: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L287: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L288: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x20", 2));
L289: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L290: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L291: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L292: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L293: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L294: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L295: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L296: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[3]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string);
  }
L297: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L298: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string3);
    }
  }
L299: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L300: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L301: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x62\x20", 2));
L302: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L303: // CONCAT
  {
    void* string1 = object_vars[4];
    void* string2 = object_vars[5];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string3);
    }
  }
L304: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L305: // MOVE_CONSTANT_INT
  int_vars[4] = 10;
L306: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L307: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object); 
      } 
    } 
  } 
L308: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L309: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[7];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L310: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L311: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L312: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[5]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], string);
  }
L313: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L314: // CONCAT
  {
    void* string1 = object_vars[6];
    void* string2 = object_vars[8];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], string3);
    }
  }
L315: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L316: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L317: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], env->new_string_len_raw(env, "\x20\x63", 2));
L318: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L319: // CONCAT
  {
    void* string1 = object_vars[9];
    void* string2 = object_vars[10];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], string3);
    }
  }
L320: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L321: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], NULL);
L322: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], NULL);
L323: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L324: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L325: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L326: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L327: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L328: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L329: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L330: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L331: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L332: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x20\x35\x62\x20\x31\x31\x20\x63", 9));
L333: // STRING_EQ
  {
    void* object1 = object_vars[11];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L334: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Literal::String";
    const char* sub_name = "var_expansion";
    const char* file = "TestCase/Literal/String.spvm";
    int32_t line = 303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L347;
  }
L335: // BOOL_INT
  int_vars[0] = int_vars[0];
L336: // IF_NE_ZERO
  if (int_vars[0]) { goto L341; }
L337: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L338: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L339: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L347;
L340: // GOTO
  goto L341;
L341: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 16;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L342: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L343: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L344: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L347;
L345: // INIT_INT
  int_vars[6] = 0;
L346: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L347;
L347: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L348: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


